/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.other;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class WirelessIOContainer
extends AbstractContainerMenu {
    public static final MenuType<WirelessIOContainer> TYPE = IMenuTypeExtension.create((windowId, inv, data) -> new WirelessIOContainer(windowId, inv, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)data)));
    private final ItemStack wirelessIO;
    private final ItemStackHandler filterListInv;

    public WirelessIOContainer(int id, Inventory inventory, ItemStack wirelessIO) {
        super(TYPE, id);
        this.wirelessIO = wirelessIO;
        this.filterListInv = ItemWirelessIO.getFilterList((HolderLookup.Provider)inventory.player.registryAccess(), wirelessIO);
        this.addPlayerSlots(inventory);
        this.addWirelessIOSlots();
    }

    public boolean stillValid(Player playerIn) {
        return playerIn.getMainHandItem().getItem() == InitItems.WIRELESS_IO.get();
    }

    public void clicked(int slotId, int button, ClickType clickTypeIn, Player player) {
        if (slotId == 27 + player.getInventory().selected) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.clicked(slotId, button, clickTypeIn, player);
        ItemWirelessIO.setFilterList((HolderLookup.Provider)player.registryAccess(), this.wirelessIO, this.filterListInv);
    }

    private void addWirelessIOSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot((Slot)new WirelessIOSlotItemHandler(this, (IItemHandler)this.filterListInv, col + row * 3, 62 + col * 18, 17 + row * 18));
            }
        }
    }

    private void addPlayerSlots(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)inventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack2 = slot.getItem();
            stack1 = stack2.copy();
            if (index < 27 ? !this.moveItemStackTo(stack2, 27, 36, true) : !this.moveItemStackTo(stack2, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (stack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack1;
    }

    public ItemStack getWirelessIO() {
        return this.wirelessIO;
    }

    private class WirelessIOSlotItemHandler
    extends SlotItemHandler {
        private WirelessIOSlotItemHandler(WirelessIOContainer wirelessIOContainer, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return EntityMaid.canInsertItem(stack) && super.mayPlace(stack);
        }
    }
}

