/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class ItemBoardState
extends Item {
    public static final String DATA_TAG = "BoardStateData";
    public static final String DESC_TAG = "BoardStateDesc";
    public static final String AUTHOR_TAG = "BoardStateAuthor";

    public ItemBoardState() {
        super(new Item.Properties());
    }

    public static void setState(ItemStack stack, String data, String desc, String author) {
        BoardStateInfo info = new BoardStateInfo(data, desc, author);
        stack.set(InitDataComponent.BOARD_STATE_TAG, (Object)info);
    }

    @Nullable
    public static String[] getState(ItemStack stack) {
        BoardStateInfo info = (BoardStateInfo)stack.get(InitDataComponent.BOARD_STATE_TAG);
        if (info == null) {
            return null;
        }
        return new String[]{info.data(), info.description(), info.author()};
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!Screen.hasShiftDown()) {
            return Optional.empty();
        }
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            return Optional.empty();
        }
        String stateData = state[0];
        if (StringUtils.isBlank((CharSequence)stateData)) {
            return Optional.empty();
        }
        if (stack.is((Item)InitItems.GOMOKU_BOARD_STATE.get())) {
            return Optional.of(BoardStateTooltip.ofGomoku(stateData));
        }
        if (stack.is((Item)InitItems.CCHESS_BOARD_STATE.get())) {
            return Optional.of(BoardStateTooltip.ofXiangqi(stateData));
        }
        if (stack.is((Item)InitItems.WCHESS_BOARD_STATE.get())) {
            return Optional.of(BoardStateTooltip.ofChess(stateData));
        }
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        String author;
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.board_state.empty").withStyle(ChatFormatting.GRAY));
            return;
        }
        String descKey = state[1];
        if (StringUtils.isNotBlank((CharSequence)descKey)) {
            tooltip.add((Component)Component.translatable((String)descKey).withStyle(ChatFormatting.GRAY));
        }
        if (StringUtils.isNotBlank((CharSequence)(author = state[2]))) {
            tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.board_state.author", (Object[])new Object[]{author}).withStyle(ChatFormatting.GRAY));
        }
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"board_state.touhou_little_maid.show_picture").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    public record BoardStateInfo(String data, String description, String author) {
        public static final Codec<BoardStateInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("data").forGetter(BoardStateInfo::data), (App)Codec.STRING.fieldOf("description").forGetter(BoardStateInfo::description), (App)Codec.STRING.fieldOf("author").forGetter(BoardStateInfo::author)).apply((Applicative)instance, BoardStateInfo::new));
        public static final StreamCodec<ByteBuf, BoardStateInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, BoardStateInfo::data, (StreamCodec)ByteBufCodecs.STRING_UTF8, BoardStateInfo::description, (StreamCodec)ByteBufCodecs.STRING_UTF8, BoardStateInfo::author, BoardStateInfo::new);
    }
}

