/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.other.WirelessIOContainer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ItemWirelessIO
extends Item
implements MenuProvider {
    private static final int FILTER_LIST_SIZE = 9;
    private static final String TOOLTIPS_PREFIX = "\u00a7a\u258d \u00a77";

    public ItemWirelessIO() {
        super(new Item.Properties().stacksTo(1));
    }

    public static void setMode(ItemStack stack, boolean maidToChest) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            stack.set(InitDataComponent.IO_MODE, (Object)maidToChest);
        }
    }

    public static boolean isMaidToChest(ItemStack stack) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            return Objects.requireNonNullElse((Boolean)stack.get(InitDataComponent.IO_MODE), false);
        }
        return false;
    }

    public static void setFilterMode(ItemStack stack, boolean isBlacklist) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            stack.set(InitDataComponent.FILTER_MODE, (Object)isBlacklist);
        }
    }

    public static boolean isBlacklist(ItemStack stack) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            return Objects.requireNonNullElse((Boolean)stack.get(InitDataComponent.FILTER_MODE), false);
        }
        return false;
    }

    public static ItemStackHandler getFilterList(HolderLookup.Provider provider, ItemStack stack) {
        CompoundTag tag;
        WirelessIOHandler handler = new WirelessIOHandler(9);
        if (stack.getItem() == InitItems.WIRELESS_IO.get() && (tag = (CompoundTag)stack.get(InitDataComponent.FILTER_LIST_TAG)) != null) {
            handler.deserializeNBT(provider, tag);
        }
        return handler;
    }

    public static void setFilterList(HolderLookup.Provider provider, ItemStack stack, ItemStackHandler itemStackHandler) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            stack.set(InitDataComponent.FILTER_LIST_TAG, (Object)itemStackHandler.serializeNBT(provider));
        }
    }

    @Nullable
    public static BlockPos getBindingPos(ItemStack stack) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            return (BlockPos)stack.get(InitDataComponent.BINDING_POS);
        }
        return null;
    }

    public static void setBindingPos(ItemStack stack, BlockPos pos) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            stack.set(InitDataComponent.BINDING_POS, (Object)pos);
        }
    }

    public static void setSlotConfig(ItemStack stack, List<Boolean> config) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            stack.set(InitDataComponent.SLOT_CONFIG_TAG, config);
        }
    }

    @Nullable
    public static List<Boolean> getSlotConfig(ItemStack stack) {
        if (stack.getItem() == InitItems.WIRELESS_IO.get()) {
            return (List)stack.get(InitDataComponent.SLOT_CONFIG_TAG);
        }
        return null;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (hand != InteractionHand.MAIN_HAND) {
            return super.useOn(context);
        }
        if (player == null) {
            return super.useOn(context);
        }
        for (IChestType type : ChestManager.getAllChestTypes()) {
            if (!type.isChest(te) || !type.canOpenByPlayer(te, player)) continue;
            ItemStack stack = player.getMainHandItem();
            ItemWirelessIO.setBindingPos(stack, pos);
            return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND && playerIn instanceof ServerPlayer) {
            playerIn.openMenu((MenuProvider)this, buffer -> ItemStack.STREAM_CODEC.encode(buffer, (Object)playerIn.getMainHandItem()));
            return InteractionResultHolder.success((Object)playerIn.getMainHandItem());
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean maidToChest = ItemWirelessIO.isMaidToChest(stack);
        boolean isBlacklist = ItemWirelessIO.isBlacklist(stack);
        BlockPos pos = ItemWirelessIO.getBindingPos(stack);
        String ioModeText = maidToChest ? I18n.get((String)"tooltips.touhou_little_maid.wireless_io.io_mode.input", (Object[])new Object[0]) : I18n.get((String)"tooltips.touhou_little_maid.wireless_io.io_mode.output", (Object[])new Object[0]);
        String filterModeText = isBlacklist ? I18n.get((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist", (Object[])new Object[0]) : I18n.get((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist", (Object[])new Object[0]);
        String hasPos = pos != null ? I18n.get((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.has", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}) : I18n.get((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.none", (Object[])new Object[0]);
        tooltip.add((Component)Component.literal((String)(TOOLTIPS_PREFIX + ioModeText)));
        tooltip.add((Component)Component.literal((String)(TOOLTIPS_PREFIX + filterModeText)));
        tooltip.add((Component)Component.literal((String)(TOOLTIPS_PREFIX + hasPos)));
        tooltip.add((Component)Component.literal((String)" "));
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.wireless_io.usage.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.wireless_io.usage.2").withStyle(ChatFormatting.GRAY));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"item.touhou_little_maid.wireless_io");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new WirelessIOContainer(id, inventory, player.getMainHandItem());
    }

    private static class WirelessIOHandler
    extends ItemStackHandler {
        private WirelessIOHandler(int size) {
            super(size);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

