/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin.client;

import com.github.tartaricacid.touhoulittlemaid.client.input.DismountBroomKey;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class ClientPacketListenerMixin {
    @Shadow
    private ClientLevel level;

    @Inject(method={"handleSetEntityPassengersPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void tlmHandleSetEntityPassengersPacket(ClientboundSetPassengersPacket packet, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener listener = (ClientPacketListener)this;
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)listener, (BlockableEventLoop)minecraft);
        Entity vehicleEntity = this.level.getEntity(packet.getVehicle());
        LocalPlayer player = minecraft.player;
        if (!(vehicleEntity instanceof EntityBroom) || player == null) {
            return;
        }
        boolean playerWasPassenger = vehicleEntity.hasIndirectPassenger((Entity)player);
        vehicleEntity.ejectPassengers();
        for (int passengerId : packet.getPassengers()) {
            Entity passengerEntity = this.level.getEntity(passengerId);
            if (passengerEntity == null) continue;
            passengerEntity.startRiding(vehicleEntity, true);
            if (passengerEntity != player || playerWasPassenger) continue;
            MutableComponent mountMessage = Component.translatable((String)"mount.onboard", (Object[])new Object[]{DismountBroomKey.DISMOUNT_KEY.getTranslatedKeyMessage()});
            minecraft.gui.setOverlayMessage((Component)mountMessage, false);
            minecraft.getNarrator().sayNow((Component)mountMessage);
        }
        ci.cancel();
    }
}

