/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SetMaidSoundIdPackage(int entityId, String soundId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetMaidSoundIdPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("set_maid_sound_id"));
    public static final StreamCodec<ByteBuf, SetMaidSoundIdPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetMaidSoundIdPackage::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SetMaidSoundIdPackage::soundId, SetMaidSoundIdPackage::new);

    public static void handle(SetMaidSoundIdPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                    maid.setSoundPackId(message.soundId);
                    ((MaidEventTrigger)((Object)((Object)InitTrigger.MAID_EVENT.get()))).trigger(sender, "change_maid_sound");
                }
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

