/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public record TTSSystemAudioToClientPackage(String siteName, String chatText, TTSConfig config, TTSSystemServices services) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TTSSystemAudioToClientPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("tts_system_audio_to_client"));
    public static final StreamCodec<ByteBuf, TTSSystemAudioToClientPackage> STREAM_CODEC = new StreamCodec<ByteBuf, TTSSystemAudioToClientPackage>(){

        public TTSSystemAudioToClientPackage decode(ByteBuf byteBuf) {
            FriendlyByteBuf buf = new FriendlyByteBuf(byteBuf);
            String siteName = buf.readUtf();
            TTSSite ttsSite = AvailableSites.getTTSSite(siteName);
            TTSClient tTSClient = ttsSite.client();
            if (tTSClient instanceof TTSSystemServices) {
                TTSSystemServices services = (TTSSystemServices)((Object)tTSClient);
                Pair<String, TTSConfig> pair = services.readFromNetwork(buf);
                return new TTSSystemAudioToClientPackage(siteName, (String)pair.getLeft(), (TTSConfig)pair.getRight(), services);
            }
            throw new IllegalArgumentException("Invalid TTS site: " + siteName);
        }

        public void encode(ByteBuf byteBuf, TTSSystemAudioToClientPackage message) {
            FriendlyByteBuf buf = new FriendlyByteBuf(byteBuf);
            buf.writeUtf(message.siteName);
            message.services.writeToNetwork(message.chatText, message.config, buf);
        }
    };

    public static void handle(TTSSystemAudioToClientPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> TTSSystemAudioToClientPackage.onHandle(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(TTSSystemAudioToClientPackage message) {
        TTSSite ttsSite = AvailableSites.getTTSSite(message.siteName);
        if (ttsSite == null || !ttsSite.enabled()) {
            return;
        }
        ttsSite.client().play(message.chatText, message.config, null);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

