/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.AltarItemHandler;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileEntityAltar
extends BlockEntity {
    public static final BlockEntityType<TileEntityAltar> TYPE = BlockEntityType.Builder.of(TileEntityAltar::new, (Block[])new Block[]{(Block)InitBlocks.ALTAR.get()}).build(null);
    private static final String STORAGE_ITEM = "StorageItem";
    private static final String IS_RENDER = "IsRender";
    private static final String CAN_PLACE_ITEM = "CanPlaceItem";
    private static final String STORAGE_STATE_ID = "StorageBlockStateId";
    private static final String DIRECTION = "Direction";
    private static final String STORAGE_BLOCK_LIST = "StorageBlockList";
    private static final String CAN_PLACE_ITEM_POS_LIST = "CanPlaceItemPosList";
    public final ItemStackHandler handler = new AltarItemHandler();
    private boolean isRender = false;
    private boolean canPlaceItem = false;
    private BlockState storageState = Blocks.AIR.defaultBlockState();
    private PosListData blockPosList = new PosListData();
    private PosListData canPlaceItemPosList = new PosListData();
    private Direction direction = Direction.SOUTH;

    public TileEntityAltar(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void setForgeData(BlockState storageState, boolean isRender, boolean canPlaceItem, Direction direction, PosListData blockPosList, PosListData canPlaceItemPosList) {
        this.isRender = isRender;
        this.canPlaceItem = canPlaceItem;
        this.storageState = storageState;
        this.direction = direction;
        this.blockPosList = blockPosList;
        this.canPlaceItemPosList = canPlaceItemPosList;
        this.refresh();
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.getPersistentData().putBoolean(IS_RENDER, this.isRender);
        this.getPersistentData().putBoolean(CAN_PLACE_ITEM, this.canPlaceItem);
        this.getPersistentData().putInt(STORAGE_STATE_ID, Block.getId((BlockState)this.storageState));
        this.getPersistentData().put(STORAGE_ITEM, (Tag)this.handler.serializeNBT(pRegistries));
        this.getPersistentData().putString(DIRECTION, this.direction.getSerializedName());
        this.getPersistentData().put(STORAGE_BLOCK_LIST, (Tag)this.blockPosList.serialize());
        this.getPersistentData().put(CAN_PLACE_ITEM_POS_LIST, (Tag)this.canPlaceItemPosList.serialize());
        super.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.isRender = this.getPersistentData().getBoolean(IS_RENDER);
        this.canPlaceItem = this.getPersistentData().getBoolean(CAN_PLACE_ITEM);
        this.storageState = Block.stateById((int)this.getPersistentData().getInt(STORAGE_STATE_ID));
        this.handler.deserializeNBT(pRegistries, this.getPersistentData().getCompound(STORAGE_ITEM));
        this.direction = Direction.byName((String)this.getPersistentData().getString(DIRECTION));
        this.blockPosList.deserialize(this.getPersistentData().getList(STORAGE_BLOCK_LIST, 11));
        this.canPlaceItemPosList.deserialize(this.getPersistentData().getList(CAN_PLACE_ITEM_POS_LIST, 11));
    }

    public BlockPos getWorldPosition() {
        return this.worldPosition;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void refresh() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public boolean isRender() {
        return this.isRender;
    }

    public boolean isCanPlaceItem() {
        return this.canPlaceItem;
    }

    public BlockState getStorageState() {
        return this.storageState;
    }

    public PosListData getBlockPosList() {
        return this.blockPosList;
    }

    public PosListData getCanPlaceItemPosList() {
        return this.canPlaceItemPosList;
    }

    public ItemStack getStorageItem() {
        if (this.canPlaceItem) {
            return this.handler.getStackInSlot(0);
        }
        return ItemStack.EMPTY;
    }

    public Direction getDirection() {
        return this.direction;
    }
}

