/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityStatue
extends BlockEntity {
    public static final BlockEntityType<TileEntityStatue> TYPE = BlockEntityType.Builder.of(TileEntityStatue::new, (Block[])new Block[]{(Block)InitBlocks.STATUE.get()}).build(null);
    private static final String STATUE_SIZE_TAG = "StatueSize";
    private static final String CORE_BLOCK_TAG = "CoreBlock";
    private static final String CORE_BLOCK_POS_TAG = "CoreBlockPos";
    private static final String STATUE_FACING_TAG = "StatueFacing";
    private static final String ALL_BLOCKS_TAG = "AllBlocks";
    private static final String EXTRA_MAID_DATA = "ExtraMaidData";
    private Size size = Size.SMALL;
    private boolean isCoreBlock = false;
    private BlockPos coreBlockPos = BlockPos.ZERO;
    private Direction facing = Direction.NORTH;
    private List<BlockPos> allBlocks = Lists.newArrayList();
    @Nullable
    private CompoundTag extraMaidData = null;

    public TileEntityStatue(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void setForgeData(Size size, boolean isCoreBlock, BlockPos coreBlockPos, Direction facing, List<BlockPos> allBlocks, @Nullable CompoundTag extraData) {
        this.size = size;
        this.isCoreBlock = isCoreBlock;
        this.coreBlockPos = coreBlockPos;
        this.facing = facing;
        this.allBlocks = allBlocks;
        this.extraMaidData = extraData;
        this.refresh();
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.getPersistentData().putInt(STATUE_SIZE_TAG, this.size.ordinal());
        this.getPersistentData().putBoolean(CORE_BLOCK_TAG, this.isCoreBlock);
        this.getPersistentData().put(CORE_BLOCK_POS_TAG, NbtUtils.writeBlockPos((BlockPos)this.coreBlockPos));
        this.getPersistentData().putString(STATUE_FACING_TAG, this.facing.getSerializedName());
        ListTag blockList = new ListTag();
        for (BlockPos pos : this.allBlocks) {
            blockList.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        this.getPersistentData().put(ALL_BLOCKS_TAG, (Tag)blockList);
        if (this.extraMaidData != null) {
            this.getPersistentData().put(EXTRA_MAID_DATA, (Tag)this.extraMaidData);
        }
        super.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.size = Size.getSizeByIndex(this.getPersistentData().getInt(STATUE_SIZE_TAG));
        this.isCoreBlock = this.getPersistentData().getBoolean(CORE_BLOCK_TAG);
        NbtUtils.readBlockPos((CompoundTag)this.getPersistentData(), (String)CORE_BLOCK_POS_TAG).ifPresent(pos -> {
            this.coreBlockPos = pos;
        });
        this.facing = Direction.byName((String)this.getPersistentData().getString(STATUE_FACING_TAG));
        this.allBlocks.clear();
        ListTag blockList = this.getPersistentData().getList(ALL_BLOCKS_TAG, 10);
        for (int i = 0; i < blockList.size(); ++i) {
            int[] pos2 = blockList.getIntArray(i);
            this.allBlocks.add(new BlockPos(pos2[0], pos2[1], pos2[2]));
        }
        if (this.getPersistentData().contains(EXTRA_MAID_DATA, 10)) {
            this.extraMaidData = this.getPersistentData().getCompound(EXTRA_MAID_DATA);
        }
    }

    public BlockPos getWorldPosition() {
        return this.worldPosition;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void refresh() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public Size getSize() {
        return this.size;
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public BlockPos getCoreBlockPos() {
        return this.coreBlockPos;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public List<BlockPos> getAllBlocks() {
        return this.allBlocks;
    }

    @Nullable
    public CompoundTag getExtraMaidData() {
        return this.extraMaidData;
    }

    public static enum Size {
        TINY(0.5f, new Vec3i(1, 1, 1)),
        SMALL(1.0f, new Vec3i(1, 2, 1)),
        MIDDLE(2.0f, new Vec3i(2, 4, 2)),
        BIG(3.0f, new Vec3i(3, 6, 3));

        private final float scale;
        private final Vec3i dimension;

        private Size(float scale, Vec3i dimension) {
            this.scale = scale;
            this.dimension = dimension;
        }

        public static Size getSizeByIndex(int index) {
            return Size.values()[Mth.clamp((int)index, (int)0, (int)(Size.values().length - 1))];
        }

        public float getScale() {
            return this.scale;
        }

        public Vec3i getDimension() {
            return this.dimension;
        }
    }
}

