/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import org.lwjgl.system.MemoryUtil;

public final class IconCache {
    public static final int BACKGROUND_COLOR = -16711936;
    public static final int BACKGROUND_COLOR_SHIFTED = -16711936;

    public static NativeImage exportImageFromScreenshot(int scaleImage, int backgroundColor) {
        NativeImage imageFull = Screenshot.takeScreenshot((RenderTarget)Minecraft.getInstance().getMainRenderTarget());
        NativeImage image = IconCache.getSubImage(imageFull, scaleImage, scaleImage);
        imageFull.close();
        for (int cx = 0; cx < image.getWidth(); ++cx) {
            for (int cy = 0; cy < image.getHeight(); ++cy) {
                int color = image.getPixelRGBA(cx, cy);
                if (color != backgroundColor) continue;
                image.setPixelRGBA(cx, cy, 0);
            }
        }
        return image;
    }

    private static NativeImage getSubImage(NativeImage image, int width, int height) {
        NativeImage imageSub = new NativeImage(width, height, false);
        for (int y = 0; y < imageSub.getHeight(); ++y) {
            int pointerOffset = y * image.getWidth() * image.format().components();
            int pointerOffsetSub = y * imageSub.getWidth() * imageSub.format().components();
            MemoryUtil.memCopy((long)(image.pixels + (long)pointerOffset), (long)(imageSub.pixels + (long)pointerOffsetSub), (long)((long)imageSub.getWidth() * (long)image.format().components()));
        }
        return imageSub;
    }
}

