/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.entity;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.ConvertMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public interface IMaid {
    @Nullable
    public static IMaid convert(Mob mob) {
        if (mob instanceof IMaid) {
            IMaid maid = (IMaid)mob;
            return maid;
        }
        ConvertMaidEvent event = new ConvertMaidEvent(mob);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getMaid();
    }

    @Nullable
    public static EntityMaid convertToMaid(Mob mob) {
        IMaid convert = IMaid.convert(mob);
        if (convert == null) {
            return null;
        }
        return convert.asStrictMaid();
    }

    @Nullable
    default public EntityMaid asStrictMaid() {
        return null;
    }

    public String getModelId();

    default public boolean isYsmModel() {
        return false;
    }

    default public void setIsYsmModel(boolean isYsmModel) {
    }

    default public String getYsmModelId() {
        return "";
    }

    default public String getYsmModelTexture() {
        return "";
    }

    default public Component getYsmModelName() {
        return Component.empty();
    }

    default public void setYsmModel(String modelId, String texture, Component name) {
    }

    default public void playRouletteAnim(String rouletteAnim) {
    }

    default public void stopRouletteAnim() {
    }

    public Mob asEntity();

    default public ItemStack[] getHandItemsForAnimation() {
        return new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY};
    }

    default public IMaidTask getTask() {
        return TaskManager.getIdleTask();
    }

    default public boolean isSwingingArms() {
        return false;
    }

    default public int getExperience() {
        return 0;
    }

    default public boolean isMaidInSittingPose() {
        return false;
    }

    default public boolean isBegging() {
        return false;
    }

    default public int getFavorability() {
        return 0;
    }

    default public ItemStack getBackpackShowItem() {
        return ItemStack.EMPTY;
    }

    default public IMaidBackpack getMaidBackpackType() {
        return BackpackManager.getEmptyBackpack();
    }

    default public boolean hasBackpack() {
        return this.getMaidBackpackType() != BackpackManager.getEmptyBackpack();
    }

    default public boolean hasHelmet() {
        return !this.asEntity().getItemBySlot(EquipmentSlot.HEAD).isEmpty();
    }

    default public boolean hasChestPlate() {
        return !this.asEntity().getItemBySlot(EquipmentSlot.CHEST).isEmpty();
    }

    default public boolean hasLeggings() {
        return !this.asEntity().getItemBySlot(EquipmentSlot.LEGS).isEmpty();
    }

    default public boolean hasBoots() {
        return !this.asEntity().getItemBySlot(EquipmentSlot.FEET).isEmpty();
    }

    default public boolean onHurt() {
        return this.asEntity().hurtTime > 0;
    }

    default public boolean hasFishingHook() {
        return false;
    }

    default public boolean onClimbable() {
        return false;
    }

    @Deprecated
    default public String getAtBiomeTemp() {
        float temp = BiomeCacheUtil.getCacheBiome((Entity)this.asEntity()).getBaseTemperature();
        if ((double)temp < 0.15) {
            return "COLD";
        }
        if ((double)temp < 0.55) {
            return "OCEAN";
        }
        if ((double)temp < 0.95) {
            return "MEDIUM";
        }
        return "WARM";
    }

    @Deprecated
    default public boolean hasSasimono() {
        return false;
    }

    @Deprecated
    default public boolean isSitInJoyBlock() {
        return false;
    }

    @Deprecated
    default public int getDim() {
        ResourceKey dim = this.asEntity().level.dimension();
        if (dim.equals(Level.OVERWORLD)) {
            return 0;
        }
        if (dim.equals(Level.NETHER)) {
            return -1;
        }
        if (dim.equals(Level.END)) {
            return 1;
        }
        return 0;
    }
}

