/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.gomoku;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Point {
    public static final int EMPTY = 0;
    public static final int BLACK = 1;
    public static final int WHITE = 2;
    public static final Point NULL = new Point(-1, -1, 0);
    public static final StreamCodec<ByteBuf, Point> POINT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Point::getX, (StreamCodec)ByteBufCodecs.INT, Point::getY, (StreamCodec)ByteBufCodecs.INT, Point::getType, Point::new);
    public final int x;
    public final int y;
    public int type;
    public int score;

    public Point(int x, int y, int type) {
        this.x = x;
        this.y = y;
        this.type = type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getType() {
        return this.type;
    }

    public static CompoundTag toTag(Point point) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", point.x);
        tag.putInt("y", point.y);
        tag.putInt("type", point.type);
        return tag;
    }

    public static Point fromTag(CompoundTag tag) {
        int x = tag.getInt("x");
        int y = tag.getInt("y");
        int type = tag.getInt("type");
        return new Point(x, y, type);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof Point) {
            Point otherPoint = (Point)other;
            return otherPoint.x == this.x && otherPoint.y == this.y && otherPoint.type == this.type;
        }
        return false;
    }

    public String toString() {
        return (this.type == 1 ? "Black" : "White") + "[" + this.x + "," + this.y + "]";
    }
}

