/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;

public class BlockStatue
extends Block
implements EntityBlock {
    public static final BooleanProperty IS_TINY = BooleanProperty.create((String)"is_tiny");
    public static final IClientBlockExtensions CLIENT_BLOCK_EXTENSIONS = FMLEnvironment.dist == Dist.CLIENT ? new IClientBlockExtensions(){

        public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult blockTarget = (BlockHitResult)target;
                if (world instanceof ClientLevel) {
                    ClientLevel clientWorld = (ClientLevel)world;
                    BlockPos pos = blockTarget.getBlockPos();
                    this.crack(clientWorld, pos, Blocks.CLAY.defaultBlockState(), blockTarget.getDirection());
                }
            }
            return true;
        }

        public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
            Minecraft.getInstance().particleEngine.destroy(pos, Blocks.CLAY.defaultBlockState());
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
            if (state.getRenderShape() != RenderShape.INVISIBLE) {
                int posX = pos.getX();
                int posY = pos.getY();
                int posZ = pos.getZ();
                AABB aabb = state.getShape((BlockGetter)world, pos).bounds();
                double x = (double)posX + world.random.nextDouble() * (aabb.maxX - aabb.minX - 0.2) + 0.1 + aabb.minX;
                double y = (double)posY + world.random.nextDouble() * (aabb.maxY - aabb.minY - 0.2) + 0.1 + aabb.minY;
                double z = (double)posZ + world.random.nextDouble() * (aabb.maxZ - aabb.minZ - 0.2) + 0.1 + aabb.minZ;
                if (side == Direction.DOWN) {
                    y = (double)posY + aabb.minY - 0.1;
                }
                if (side == Direction.UP) {
                    y = (double)posY + aabb.maxY + 0.1;
                }
                if (side == Direction.NORTH) {
                    z = (double)posZ + aabb.minZ - 0.1;
                }
                if (side == Direction.SOUTH) {
                    z = (double)posZ + aabb.maxZ + 0.1;
                }
                if (side == Direction.WEST) {
                    x = (double)posX + aabb.minX - 0.1;
                }
                if (side == Direction.EAST) {
                    x = (double)posX + aabb.maxX + 0.1;
                }
                TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                Minecraft.getInstance().particleEngine.add(diggingParticle.updateSprite(state, pos).setPower(0.2f).scale(0.6f));
            }
        }
    } : null;

    public BlockStatue() {
        super(BlockBehaviour.Properties.of().sound(SoundType.MUD).strength(1.0f, 2.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_TINY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.isClientSide) {
            this.getStatue((BlockGetter)worldIn, pos).ifPresent(statue -> {
                this.restoreClayBlock(worldIn, pos, (TileEntityStatue)((Object)statue));
                if (!player.isCreative()) {
                    Block.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.CLAY));
                }
            });
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.isClientSide) {
            this.getStatue((BlockGetter)world, pos).ifPresent(statue -> this.restoreClayBlock(world, pos, (TileEntityStatue)((Object)statue)));
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_TINY});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityStatue(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private Optional<TileEntityStatue> getStatue(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityStatue) {
            return Optional.of((TileEntityStatue)te);
        }
        return Optional.empty();
    }

    private void restoreClayBlock(@Nonnull Level worldIn, @Nonnull BlockPos pos, TileEntityStatue statue) {
        List<BlockPos> posList = statue.getAllBlocks();
        for (BlockPos storagePos : posList) {
            if (storagePos.equals((Object)pos)) continue;
            this.getStatue((BlockGetter)worldIn, storagePos).ifPresent(s -> worldIn.setBlock(storagePos, Blocks.CLAY.defaultBlockState(), 3));
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)IS_TINY);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (worldIn.getBlockState(pos.below()).is(Blocks.FIRE)) {
            this.getStatue((BlockGetter)worldIn, pos).ifPresent(statue -> {
                worldIn.setBlockAndUpdate(pos, ((Block)InitBlocks.GARAGE_KIT.get()).defaultBlockState());
                worldIn.levelEvent(1009, pos, 0);
                BlockEntity te = worldIn.getBlockEntity(pos);
                if (te instanceof TileEntityGarageKit && statue.getExtraMaidData() != null) {
                    ((TileEntityGarageKit)te).setData(statue.getFacing(), statue.getExtraMaidData());
                }
            });
        }
    }
}

