/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.AIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class PressAIChatKeyEvent {
    @SubscribeEvent
    public static void onOpenConfig(InputEvent.Key event) {
        if (PressAIChatKeyEvent.isInGame() && ((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue() && PressAIChatKeyEvent.keyIsMatch(event)) {
            EntityMaid maid = PressAIChatKeyEvent.maidCheck();
            if (maid == null) {
                return;
            }
            Minecraft.getInstance().options.keyChat.consumeClick();
            Minecraft.getInstance().setScreen((Screen)new AIChatScreen(maid));
        }
    }

    private static boolean keyIsMatch(InputEvent.Key event) {
        KeyMapping keyChat = Minecraft.getInstance().options.keyChat;
        return event.getAction() == 1 && keyChat.matches(event.getKey(), event.getScanCode()) && keyChat.getKeyModifier().equals((Object)KeyModifier.getActiveModifier());
    }

    @Nullable
    private static EntityMaid maidCheck() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return null;
        }
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof EntityHitResult)) {
            return null;
        }
        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
        Entity entity = entityHitResult.getEntity();
        if (!(entity instanceof EntityMaid)) {
            return null;
        }
        EntityMaid maid = (EntityMaid)entity;
        if (!maid.isOwnedBy((LivingEntity)player)) {
            return null;
        }
        return maid;
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getOverlay() != null) {
            return false;
        }
        if (mc.screen != null) {
            return false;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return false;
        }
        return mc.isWindowActive();
    }
}

