/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.CacheIconTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.IconCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.time.StopWatch;

@OnlyIn(value=Dist.CLIENT)
public class CacheScreen<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    protected final Screen parent;
    protected final EntityType<T> entityType;
    protected final Queue<E> modelInfos;
    protected final EntityRender<T, E> entityRender;
    protected final int totalCount;
    protected final StopWatch stopWatch;

    public CacheScreen(Screen parent, EntityType<T> entityType, Queue<E> modelInfos, EntityRender<T, E> entityRender) {
        super((Component)Component.literal((String)"Cache Screen"));
        this.parent = parent;
        this.entityType = entityType;
        this.modelInfos = modelInfos;
        this.entityRender = entityRender;
        this.totalCount = modelInfos.size();
        this.stopWatch = StopWatch.createStarted();
    }

    private void drawEntity(GuiGraphics graphics, int posX, int posY, E modelInfo, int scaleModified) {
        LivingEntity entity;
        ClientLevel world = this.getMinecraft().level;
        if (world == null) {
            return;
        }
        try {
            entity = (LivingEntity)EntityCacheUtil.ENTITY_CACHE.get(this.entityType, () -> this.lambda$drawEntity$0((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.fillInStackTrace();
            return;
        }
        this.entityRender.render(graphics, posX, posY, modelInfo, scaleModified, entity);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.modelInfos.isEmpty()) {
            this.stopWatch.stop();
            double timeCost = (double)this.stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0;
            TouhouLittleMaid.LOGGER.info("Cache icon time: {} seconds", (Object)timeCost);
            Minecraft.getInstance().setScreen(this.parent);
            return;
        }
        graphics.pose().pushPose();
        for (int i = 0; i < 5; ++i) {
            if (this.modelInfos.isEmpty()) {
                return;
            }
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            this.doCacheIcon(graphics);
        }
        graphics.pose().popPose();
        int finishSize = this.totalCount - this.modelInfos.size();
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.cache_screen.progress", (Object[])new Object[]{finishSize, this.totalCount}), this.width / 2, this.height - 42, 0xFFFFFF);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.cache_screen.desc"), this.width / 2, this.height - 30, 0xFFFFFF);
    }

    protected void doCacheIcon(GuiGraphics graphics) {
        IModelInfo modelInfo = (IModelInfo)this.modelInfos.poll();
        if (modelInfo != null) {
            double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
            int scaleModified = (int)Math.ceil(256.0 / guiScale);
            graphics.fill(0, 0, scaleModified, scaleModified + 2, -16711936);
            this.drawEntity(graphics, 0, 0, modelInfo, scaleModified);
            NativeImage nativeImage = IconCache.exportImageFromScreenshot(256, -16711936);
            ResourceLocation modelId = modelInfo.getModelId();
            CacheIconTexture cacheIconTexture = new CacheIconTexture(modelId, nativeImage);
            Minecraft.getInstance().getTextureManager().register(modelInfo.getCacheIconId(), (AbstractTexture)cacheIconTexture);
        }
    }

    private /* synthetic */ Entity lambda$drawEntity$0(Level world) throws Exception {
        return this.entityType.create(world);
    }

    public static interface EntityRender<T extends LivingEntity, E extends IModelInfo> {
        public void render(GuiGraphics var1, int var2, int var3, E var4, int var5, T var6);
    }
}

