/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.bean.MetaData;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataPackage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SettingEditScreen
extends Screen {
    private static final long MAX_TIP_TIME = 2000L;
    private final EntityMaid maid;
    private final MaidAIChatManager manager;
    private EditBox ownerName;
    private MultiLineEditBox customSetting;
    private long tipTimestamp = -1L;

    public SettingEditScreen(EntityMaid maid) {
        super((Component)Component.literal((String)"Setting Edit Screen"));
        this.maid = maid;
        this.manager = maid.getAiChatManager();
    }

    protected void init() {
        this.clearWidgets();
        int posX = this.width / 2 - 195;
        int boxWidth = 256;
        this.ownerName = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, posX + 1, 30, boxWidth - 2, 20, (Component)Component.literal((String)"Owner Name Box")));
        this.ownerName.setValue(this.manager.ownerName);
        this.ownerName.setMaxLength(128);
        this.ownerName.setResponder(s -> {
            this.manager.ownerName = s;
        });
        this.customSetting = (MultiLineEditBox)this.addRenderableWidget((GuiEventListener)new MultiLineEditBox(this.font, posX, 70, boxWidth, this.height - 100, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit"), (Component)Component.literal((String)"Custom Setting Box")));
        this.customSetting.setValue(this.manager.customSetting);
        this.customSetting.setCharacterLimit(4096);
        this.customSetting.setValueListener(s -> {
            this.manager.customSetting = s;
        });
        MutableComponent export = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)export, b -> this.exportSetting(export)).bounds(posX + 265, this.ownerName.getY(), 128, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"selectWorld.edit.save"), b -> {
            this.saveConfig();
            this.tipTimestamp = System.currentTimeMillis();
        }).bounds(posX + 265, this.customSetting.getY(), 128, 20).build());
        MutableComponent saveQuit = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.save_and_quit");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)saveQuit, b -> {
            this.saveConfig();
            Minecraft.getInstance().setScreen(null);
        }).bounds(posX + 265, this.customSetting.getY() + 25, 128, 20).build());
    }

    private void exportSetting(MutableComponent export) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            String title = export.getString();
            String defaultFileName = "%s.yml".formatted(this.maid.getName().getString());
            String path = SettingReader.getSettingsFolder().resolve(defaultFileName).toString();
            String fileFilter = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.format").getString();
            PointerBuffer filterPattern = memoryStack.mallocPointer(1);
            filterPattern.put(memoryStack.UTF8((CharSequence)"*.yml"));
            filterPattern.flip();
            String result = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)path, (PointerBuffer)filterPattern, (CharSequence)fileFilter);
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            File exportFile = new File(result);
            MetaData metaData = this.getMetaData();
            CharacterSetting setting = new CharacterSetting(metaData, this.customSetting.getValue());
            setting.save(exportFile);
            if (this.getMinecraft().player != null) {
                MutableComponent tip = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.success", (Object[])new Object[]{result}).withStyle(ChatFormatting.GRAY);
                this.getMinecraft().player.sendSystemMessage((Component)tip);
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Error saving setting", (Throwable)e);
        }
    }

    @NotNull
    private MetaData getMetaData() {
        String lang = this.getMinecraft().getLanguageManager().getSelected();
        String author = "Unknown";
        if (this.getMinecraft().player != null) {
            author = this.getMinecraft().player.getScoreboardName();
        }
        String modelId = this.maid.getModelId();
        return new MetaData(0, author, Collections.singletonList(modelId), lang);
    }

    public void resize(Minecraft mc, int pWidth, int pHeight) {
        String ownerNameValue = this.ownerName.getValue();
        String customSettingValue = this.customSetting.getValue();
        super.resize(mc, pWidth, pHeight);
        this.ownerName.setValue(ownerNameValue);
        this.customSetting.setValue(customSettingValue);
    }

    public boolean mouseReleased(double x, double y, int button) {
        return super.mouseReleased(x, y, button) || this.customSetting.mouseReleased(x, y, button);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.owner_name"), this.ownerName.getX() + 2, this.ownerName.getY() - 12, 0xFFFFFF);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.custom_setting"), this.customSetting.getX() + 2, this.customSetting.getY() - 12, 0xFFFFFF);
        this.drawMaid(graphics, this.customSetting.getX() + this.customSetting.getWidth() + 73, this.customSetting.getY() + 96, this.maid);
        long time = System.currentTimeMillis() - this.tipTimestamp;
        if (time < 2000L) {
            double value = (double)time / 2000.0 * Math.PI;
            int alpha = (int)(Math.sin(value) * 255.0);
            alpha = Mth.clamp((int)alpha, (int)15, (int)240);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.saved"), this.customSetting.getX() + this.customSetting.getWidth() + 73, this.customSetting.getY() - 12, (alpha << 24) + 0xFF1111);
        }
    }

    private void drawMaid(GuiGraphics graphics, int posX, int posY, EntityMaid rawMaid) {
        EntityMaid maid;
        ClientLevel world = this.getMinecraft().level;
        if (world == null) {
            return;
        }
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(rawMaid.getModelId());
        if (info.isEmpty()) {
            return;
        }
        MaidModelInfo modelInfo = info.get();
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> SettingEditScreen.lambda$drawMaid$6((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.fillInStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (modelInfo.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(modelInfo.getModelId().toString());
        }
        maid.setIsYsmModel(false);
        float renderItemScale = modelInfo.getRenderItemScale();
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(posX - 45), (int)(posY - 45), (int)(posX + 45), (int)(posY + 55), (int)((int)(45.0f * renderItemScale)), (float)0.1f, (float)(posX - 15), (float)posY, (LivingEntity)maid);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void saveConfig() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SaveMaidAIDataPackage(this.maid.getId(), this.manager), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static /* synthetic */ Entity lambda$drawMaid$6(Level world) throws Exception {
        Entity e = EntityMaid.TYPE.create(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

