/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.SupportLanguage;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.HistoryAIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.SettingEditScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidAIChatConfigButton;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidAIChatConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataPackage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class MaidAIChatConfigContainerGui
extends AbstractMaidContainerGui<MaidAIChatConfigContainer> {
    private static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_ai_chat_config.png");
    private final MaidAIChatManager manager;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;
    private final List<String> sttSites = Lists.newArrayList(AvailableSites.STT_SITES.keySet());

    public MaidAIChatConfigContainerGui(MaidAIChatConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.maid.getAiChatManager().readFromTag(screenContainer.getConfigData());
        this.manager = this.maid.getAiChatManager();
        this.llmSites = screenContainer.getLLMSites();
        this.ttsSites = screenContainer.getTTSSites();
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        graphics.blit(ICON, this.leftPos + 80, this.topPos + 28, 0, 0, 176, 137);
    }

    @Override
    protected void initAdditionWidgets() {
        int buttonLeft = this.leftPos + 86;
        int buttonTop = this.topPos + 38;
        this.addConfigButtons(buttonLeft, buttonTop);
        this.addOtherButtons(buttonLeft);
    }

    private void addOtherButtons(int buttonLeft) {
        MutableComponent edit = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit");
        MutableComponent history = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.open_history_chat");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)edit, button -> {
            this.init();
            this.saveConfig();
            this.getMinecraft().setScreen((Screen)new SettingEditScreen(this.maid));
        }).bounds(buttonLeft + 2, this.topPos + 120, 160, 18).tooltip(Tooltip.create((Component)edit)).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)history, button -> {
            this.saveConfig();
            this.getMinecraft().setScreen((Screen)new HistoryAIChatScreen(this.maid));
        }).bounds(buttonLeft + 2, this.topPos + 140, 160, 18).tooltip(Tooltip.create((Component)history)).build());
    }

    private void addConfigButtons(int buttonLeft, int buttonTop) {
        MutableComponent noSiteSelectedName = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.no_site_selected");
        MutableComponent llmSiteName = Component.literal((String)this.manager.llmSite);
        MutableComponent ttsSiteName = Component.literal((String)this.manager.ttsSite);
        this.addRenderableWidget((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.llm_site"), (Component)(this.manager.llmSite.isBlank() ? noSiteSelectedName : llmSiteName), button -> {
            this.manager.llmSite = this.onClickSites(this.llmSites, this.manager.llmSite, button, true);
            this.init();
            this.saveConfig();
        }, button -> {
            this.manager.llmSite = this.onClickSites(this.llmSites, this.manager.llmSite, button, false);
            this.init();
            this.saveConfig();
        }));
        buttonTop += 13;
        Map<String, String> llmModels = this.llmSites.get(this.manager.llmSite);
        if (llmModels != null && !llmModels.isEmpty()) {
            String name = llmModels.get(this.manager.llmModel);
            if (StringUtils.isBlank((CharSequence)name)) {
                this.manager.llmModel = llmModels.keySet().iterator().next();
                name = llmModels.get(this.manager.llmModel);
            }
            this.addRenderableWidget((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.llm_model"), (Component)Component.literal((String)name), button -> {
                this.manager.llmModel = this.onClickModels(llmModels, this.manager.llmModel, button, true);
                this.saveConfig();
            }, button -> {
                this.manager.llmModel = this.onClickModels(llmModels, this.manager.llmModel, button, false);
                this.saveConfig();
            }));
            buttonTop += 13;
        }
        this.addRenderableWidget((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_site"), (Component)(this.manager.ttsSite.isBlank() ? noSiteSelectedName : ttsSiteName), button -> {
            this.manager.ttsSite = this.onClickSites(this.ttsSites, this.manager.ttsSite, button, true);
            this.init();
            this.saveConfig();
        }, button -> {
            this.manager.ttsSite = this.onClickSites(this.ttsSites, this.manager.ttsSite, button, false);
            this.init();
            this.saveConfig();
        }));
        buttonTop += 13;
        Map<String, String> ttsModels = this.ttsSites.get(this.manager.ttsSite);
        if (ttsModels != null && !ttsModels.isEmpty()) {
            String name = ttsModels.get(this.manager.ttsModel);
            if (StringUtils.isBlank((CharSequence)name)) {
                this.manager.ttsModel = ttsModels.keySet().iterator().next();
                name = ttsModels.get(this.manager.ttsModel);
            }
            this.addRenderableWidget((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_model"), (Component)Component.literal((String)name), button -> {
                this.manager.ttsModel = this.onClickModels(ttsModels, this.manager.ttsModel, button, true);
                this.saveConfig();
            }, button -> {
                this.manager.ttsModel = this.onClickModels(ttsModels, this.manager.ttsModel, button, false);
                this.saveConfig();
            }));
            buttonTop += 13;
        }
        if (StringUtils.isBlank((CharSequence)this.manager.ttsLanguage)) {
            this.manager.ttsLanguage = SupportLanguage.SUPPORTED_LANGUAGES.get(0);
        }
        this.addRenderableWidget((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_language"), SupportLanguage.getLanguageName(this.manager.ttsLanguage), button -> {
            this.manager.ttsLanguage = SupportLanguage.findPrev(this.manager.ttsLanguage);
            button.setValue(SupportLanguage.getLanguageName(this.manager.ttsLanguage));
            this.saveConfig();
        }, button -> {
            this.manager.ttsLanguage = SupportLanguage.findNext(this.manager.ttsLanguage);
            button.setValue(SupportLanguage.getLanguageName(this.manager.ttsLanguage));
            this.saveConfig();
        }));
        this.addSttButtons(buttonLeft, buttonTop += 13);
    }

    private void addSttButtons(int buttonLeft, int buttonTop) {
        String sttType = ((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName();
        if (this.sttSites.isEmpty()) {
            sttType = "";
        } else if (!this.sttSites.contains(sttType)) {
            sttType = this.sttSites.get(0);
        }
        String finalSttType = sttType;
        this.addRenderableWidget((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"config.touhou_little_maid.global_ai.stt_type"), (Component)Component.literal((String)sttType), button -> {
            if (this.sttSites.isEmpty()) {
                return;
            }
            int index = this.sttSites.indexOf(finalSttType);
            if (index != -1) {
                if (--index < 0) {
                    index = this.sttSites.size() - 1;
                }
                AIConfig.STT_TYPE.set((Object)STTApiType.getByName(this.sttSites.get(index)));
            } else {
                AIConfig.STT_TYPE.set((Object)STTApiType.PLAYER2);
            }
            button.setValue((Component)Component.literal((String)((STTApiType)((Object)((Object)AIConfig.STT_TYPE.get()))).getName()));
            this.init();
        }, button -> {
            if (this.sttSites.isEmpty()) {
                return;
            }
            int index = this.sttSites.indexOf(finalSttType);
            if (index != -1) {
                if (++index >= this.sttSites.size()) {
                    index = 0;
                }
                AIConfig.STT_TYPE.set((Object)STTApiType.getByName(this.sttSites.get(index)));
            } else {
                AIConfig.STT_TYPE.set((Object)STTApiType.PLAYER2);
            }
            button.setValue((Component)Component.literal((String)((STTApiType)((Object)((Object)AIConfig.STT_TYPE.get()))).getName()));
            this.init();
        }));
    }

    private String onClickSites(Map<String, Map<String, String>> sites, String site, MaidAIChatConfigButton button, boolean isLeft) {
        if (sites.isEmpty()) {
            button.setValue((Component)Component.empty());
            return "";
        }
        ArrayList keys = Lists.newArrayList(sites.keySet());
        if (keys.size() == 1) {
            button.setValue((Component)Component.literal((String)((String)keys.get(0))));
            return (String)keys.get(0);
        }
        int index = keys.indexOf(site);
        if (index < 0) {
            button.setValue((Component)Component.literal((String)((String)keys.get(0))));
            return (String)keys.get(0);
        }
        if (isLeft) {
            if (--index < 0) {
                index = keys.size() - 1;
            }
        } else if (++index >= keys.size()) {
            index = 0;
        }
        String id = (String)keys.get(index);
        button.setValue((Component)Component.literal((String)id));
        return id;
    }

    private String onClickModels(Map<String, String> models, String model, MaidAIChatConfigButton button, boolean isLeft) {
        if (models.isEmpty()) {
            button.setValue((Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.default_model"));
            return "";
        }
        ArrayList keys = Lists.newArrayList(models.keySet());
        if (keys.size() == 1) {
            String id = (String)keys.get(0);
            button.setValue((Component)Component.literal((String)models.get(id)));
            return id;
        }
        int index = keys.indexOf(model);
        if (index < 0) {
            String id = (String)keys.get(0);
            button.setValue((Component)Component.literal((String)models.get(id)));
            return id;
        }
        if (isLeft) {
            if (--index < 0) {
                index = keys.size() - 1;
            }
        } else if (++index >= keys.size()) {
            index = 0;
        }
        String id = (String)keys.get(index);
        button.setValue((Component)Component.literal((String)models.get(id)));
        return id;
    }

    private void saveConfig() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SaveMaidAIDataPackage(this.maid.getId(), this.manager), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

