/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PackInfoButton
extends FlatColorButton {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/download_background.png");
    private final DownloadInfo info;

    public PackInfoButton(int pX, int pY, DownloadInfo info, Button.OnPress onPress) {
        super(pX, pY, 268, 46, (Component)Component.empty(), onPress);
        this.info = info;
        this.setTooltips(Lists.newArrayList((Object[])new Component[]{this.getI18nFormatDesc(info.getDesc()), this.getI18nFormatLicense(info.getLicense())}));
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        int count;
        Minecraft minecraft = Minecraft.getInstance();
        if (this.isSelect) {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -14774017, -14774017);
        } else if (this.info.getStatus() != DownloadStatus.DOWNLOADED) {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12369342, -12369342);
        }
        int downloadProgress = this.info.getDownloadProgress();
        if (this.info.getStatus() == DownloadStatus.DOWNLOADING && downloadProgress >= 0) {
            int widthProgress = this.width * downloadProgress / 100;
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + widthProgress, this.getY() + this.height, -43213, -43213);
        }
        if (this.info.getStatus() == DownloadStatus.NEED_UPDATE) {
            graphics.blit(BG, this.getX() + 240, this.getY() + 15, 48, 16, 16, 16);
        }
        if (this.isHoveredOrFocused()) {
            graphics.fillGradient(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.height - 1, -790560, -790560);
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, -790560, -790560);
            graphics.fillGradient(this.getX() + this.width - 1, this.getY() + 1, this.getX() + this.width, this.getY() + this.height - 1, -790560, -790560);
            graphics.fillGradient(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, -790560, -790560);
        }
        if ((count = this.info.getTypeCount()) == 3) {
            graphics.blit(BG, this.getX() + 7, this.getY() + 7, 0, 96, 32, 32);
        } else if (count == 2) {
            if (!this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
                graphics.blit(BG, this.getX() + 7, this.getY() + 7, 64, 64, 32, 32);
            } else if (!this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                graphics.blit(BG, this.getX() + 7, this.getY() + 7, 32, 64, 32, 32);
            } else {
                graphics.blit(BG, this.getX() + 7, this.getY() + 7, 0, 64, 32, 32);
            }
        } else if (this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
            graphics.blit(BG, this.getX() + 7, this.getY() + 7, 0, 32, 32, 32);
        } else if (this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
            graphics.blit(BG, this.getX() + 7, this.getY() + 7, 32, 32, 32, 32);
        } else {
            graphics.blit(BG, this.getX() + 7, this.getY() + 7, 64, 32, 32, 32);
        }
        int i = this.getFGColor();
        this.renderString(graphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        if (this.info.getStatus() == DownloadStatus.DOWNLOADED) {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 2133008930, 2133008930);
        }
    }

    @Override
    public void renderString(GuiGraphics graphics, Font font, int pColor) {
        int startX = this.getX() + 50;
        int startY = this.getY() + 4;
        MutableComponent packName = Component.translatable((String)this.info.getName());
        graphics.drawString(font, (Component)packName, startX, startY, ChatFormatting.WHITE.getColor().intValue());
        graphics.drawString(font, this.getI18nFormatFileVersion(this.info.getVersion()), startX + 5 + font.width((FormattedText)packName), startY, ChatFormatting.GREEN.getColor().intValue());
        graphics.drawString(font, (Component)this.getI18nFormatFileSize(this.info.getFormatFileSize()), startX, startY + 10, ChatFormatting.GOLD.getColor().intValue());
        graphics.drawString(font, (Component)this.getI18nFormatAuthor(this.info.getAuthor()), startX, startY + 20, ChatFormatting.AQUA.getColor().intValue());
        graphics.drawString(font, (Component)this.getI18nFormatFileTime(this.info.getFormatData()), startX, startY + 30, ChatFormatting.GRAY.getColor().intValue());
    }

    private String getI18nFormatFileVersion(String version) {
        return "\u00a7nv" + version;
    }

    private MutableComponent getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.get((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return Component.translatable((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{str});
    }

    private MutableComponent getI18nFormatFileSize(String size) {
        return Component.translatable((String)"gui.touhou_little_maid.resources_download.file_size", (Object[])new Object[]{size});
    }

    private MutableComponent getI18nFormatFileTime(String time) {
        return Component.translatable((String)"gui.touhou_little_maid.resources_download.upload_time", (Object[])new Object[]{time});
    }

    private MutableComponent getI18nFormatLicense(String license) {
        return Component.translatable((String)"gui.touhou_little_maid.resources_download.license", (Object[])new Object[]{license}).withStyle(ChatFormatting.DARK_PURPLE).withStyle(ChatFormatting.ITALIC);
    }

    private MutableComponent getI18nFormatDesc(String desc) {
        return Component.translatable((String)desc).withStyle(ChatFormatting.GRAY);
    }
}

