/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import java.io.InputStream;
import net.minecraft.util.Mth;

public class EntityBoxModel
extends SimpleBedrockModel<EntityBox> {
    private final BedrockPart x1 = this.getPart("x1");
    private final BedrockPart x2 = this.getPart("x2");
    private final BedrockPart z1 = this.getPart("z1");
    private final BedrockPart z2 = this.getPart("z2");
    private final BedrockPart top = this.getPart("top");

    public EntityBoxModel(InputStream stream) {
        super(stream);
    }

    @Override
    public void setupAnim(EntityBox entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int stage = entityIn.getOpenStage();
        if (stage == 0) {
            this.top.visible = true;
            this.x1.xRot = 0.0f;
            this.x2.xRot = 0.0f;
            this.z1.zRot = 0.0f;
            this.z2.zRot = 0.0f;
        } else if (stage == 1) {
            this.top.visible = false;
            this.x1.xRot = 0.0f;
            this.x2.xRot = 0.0f;
            this.z1.zRot = 0.0f;
            this.z2.zRot = 0.0f;
        } else {
            long timeStamp = System.currentTimeMillis() - entityIn.thirdStageTimeStamp;
            float progress = Mth.clamp((float)((float)timeStamp / 50.0f), (float)0.0f, (float)60.0f);
            this.top.visible = false;
            this.x1.xRot = 0.023998277f * progress;
            this.x2.xRot = -0.023998277f * progress;
            this.z1.zRot = 0.023998277f * progress;
            this.z2.zRot = -0.023998277f * progress;
        }
    }
}

