/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jade.provider;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum PicnicMatProvider implements IServerExtensionProvider<ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> list) {
        return ClientViewGroup.map(list, ItemView::new, null);
    }

    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
        Object object = accessor.getTarget();
        if (object instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)((Object)object);
            BlockEntity blockEntity = accessor.getLevel().getBlockEntity(picnicMat.getCenterPos());
            if (blockEntity instanceof TileEntityPicnicMat) {
                TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)blockEntity;
                ItemStackHandler handler = picnicMatCenter.getHandler();
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    list.add(stack.copy());
                }
                return List.of(new ViewGroup((List)list));
            }
        }
        return null;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"picnic_mat");
    }
}

