/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AltarRecipeCategory
implements IRecipeCategory<AltarRecipeWrapper> {
    public static final RecipeType<AltarRecipeWrapper> ALTAR = RecipeType.create((String)"touhou_little_maid", (String)"altar", AltarRecipeWrapper.class);
    private static final ResourceLocation ALTAR_ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/altar_icon.png");
    private static final ResourceLocation POWER_ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/power_point.png");
    private static final MutableComponent TITLE = Component.translatable((String)"jei.touhou_little_maid.altar_craft.title");
    private final IDrawableStatic bgDraw;
    private final IDrawable slotDraw;
    private final IDrawableStatic altarDraw;
    private final IDrawableStatic powerDraw;

    public AltarRecipeCategory(IGuiHelper guiHelper) {
        this.bgDraw = guiHelper.createBlankDrawable(160, 125);
        this.slotDraw = guiHelper.getSlotDrawable();
        this.altarDraw = guiHelper.drawableBuilder(ALTAR_ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.powerDraw = guiHelper.drawableBuilder(POWER_ICON, 32, 0, 16, 16).setTextureSize(64, 64).build();
    }

    public void draw(AltarRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int darkGray = 0x555555;
        Font font = Minecraft.getInstance().font;
        String result = I18n.get((String)"jei.touhou_little_maid.altar_craft.result", (Object[])new Object[]{I18n.get((String)recipe.getLangKey(), (Object[])new Object[0])});
        graphics.pose().pushPose();
        graphics.pose().scale(0.8f, 0.8f, 0.8f);
        this.powerDraw.draw(graphics, 90, 50);
        graphics.pose().popPose();
        graphics.drawString(font, String.format("\u00d7%.2f", Float.valueOf(recipe.getPowerCost())), 65, 55, darkGray, false);
        graphics.drawString(font, result, (int)((float)(this.bgDraw.getWidth() - font.width(result)) / 2.0f), 85, darkGray, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AltarRecipeWrapper recipe, IFocusGroup focuses) {
        List<List<ItemStack>> inputs = recipe.getInputs();
        ItemStack output = recipe.getOutput();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 35).addItemStacks(this.getInput(inputs, 0))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 55).addItemStacks(this.getInput(inputs, 1))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 60, 15).addItemStacks(this.getInput(inputs, 2))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 80, 15).addItemStacks(this.getInput(inputs, 3))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 100, 35).addItemStacks(this.getInput(inputs, 4))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 100, 55).addItemStacks(this.getInput(inputs, 5))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 5).addItemStack(output)).setBackground(this.slotDraw, -1, -1);
    }

    private List<ItemStack> getInput(List<List<ItemStack>> inputs, int index) {
        if (index < inputs.size()) {
            return inputs.get(index);
        }
        return Collections.singletonList(ItemStack.EMPTY);
    }

    public RecipeType<AltarRecipeWrapper> getRecipeType() {
        return ALTAR;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.bgDraw;
    }

    public IDrawable getIcon() {
        return this.altarDraw;
    }
}

