/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmPlantTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmSurroundingMoveTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.tartaricacid.touhoulittlemaid.util.functional.QuadFunction;
import com.github.tartaricacid.touhoulittlemaid.util.functional.QuadPredicate;
import com.github.tartaricacid.touhoulittlemaid.util.functional.TriConsumer;
import com.github.tartaricacid.touhoulittlemaid.util.functional.TriPredicate;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FarmTaskJS
implements IFarmTask {
    private final Builder builder;

    public FarmTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public ResourceLocation getUid() {
        return this.builder.id;
    }

    @Override
    public ItemStack getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_FARM.get(), 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidFarmSurroundingMoveTask maidFarmSurroundingMoveTask = new MaidFarmSurroundingMoveTask(this, 0.6f);
        MaidFarmPlantTask maidFarmPlantTask = new MaidFarmPlantTask(this);
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)maidFarmSurroundingMoveTask)), Pair.of((Object)6, (Object)((Object)maidFarmPlantTask))});
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((BehaviorControl)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean isHidden(EntityMaid maid) {
        if (this.builder.isHidden == null) {
            return false;
        }
        return this.builder.isHidden.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        if (this.builder.isSeed == null) {
            return false;
        }
        return this.builder.isSeed.test(stack);
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (this.builder.canHarvest == null) {
            return false;
        }
        return this.builder.canHarvest.test(maid, cropPos, cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (this.builder.harvest == null) {
            return;
        }
        this.builder.harvest.accept(maid, cropPos, cropState);
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (this.builder.canPlant == null) {
            return false;
        }
        return this.builder.canPlant.test(maid, basePos, baseState, seed);
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (this.builder.plant == null) {
            return seed;
        }
        return this.builder.plant.apply(maid, basePos, baseState, seed);
    }

    @Override
    public double getCloseEnoughDist() {
        return this.builder.closeEnoughDist;
    }

    @Override
    public boolean checkCropPosAbove() {
        return this.builder.checkCropPosAbove;
    }

    public static class Builder
    extends TaskBuilder<Builder, FarmTaskJS> {
        @Nullable
        private Predicate<ItemStack> isSeed = null;
        @Nullable
        private TriPredicate<EntityMaid, BlockPos, BlockState> canHarvest = null;
        @Nullable
        private TriConsumer<EntityMaid, BlockPos, BlockState> harvest = null;
        @Nullable
        private QuadPredicate<EntityMaid, BlockPos, BlockState, ItemStack> canPlant = null;
        @Nullable
        private QuadFunction<EntityMaid, BlockPos, BlockState, ItemStack, ItemStack> plant = null;
        private double closeEnoughDist = 2.0;
        private boolean checkCropPosAbove = true;

        public Builder(ResourceLocation id, ItemStack icon) {
            super(id, icon);
        }

        @Info(value="Check if the item stack is a seed. Used for the canPlant and plant methods. Mandatory. <br>\n\u5224\u65ad\u662f\u5426\u662f\u79cd\u5b50\uff0c\u7528\u4e8e\u540e\u7eed\u7684 canPlant \u548c plant \u65b9\u6cd5\u4f20\u53c2\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder isSeed(Predicate<ItemStack> isSeed) {
            this.isSeed = isSeed;
            return this;
        }

        @Info(value="Check if the maid can harvest the crop at the given position. Mandatory. <br>\n\u5224\u65ad\u5973\u4ec6\u662f\u5426\u53ef\u4ee5\u5728\u6307\u5b9a\u4f4d\u7f6e\u6536\u5272\u4f5c\u7269\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder canHarvest(TriPredicate<EntityMaid, BlockPos, BlockState> canHarvest) {
            this.canHarvest = canHarvest;
            return this;
        }

        @Info(value="Harvest the crop at the given position. Mandatory. <br>\n\u6536\u5272\u6307\u5b9a\u4f4d\u7f6e\u7684\u4f5c\u7269\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder harvest(TriConsumer<EntityMaid, BlockPos, BlockState> harvest) {
            this.harvest = harvest;
            return this;
        }

        @Info(value="Check if the maid can plant a seed at the given position. Mandatory. <br>\n\u5224\u65ad\u5973\u4ec6\u662f\u5426\u53ef\u4ee5\u5728\u6307\u5b9a\u4f4d\u7f6e\u79cd\u690d\u79cd\u5b50\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder canPlant(QuadPredicate<EntityMaid, BlockPos, BlockState, ItemStack> canPlant) {
            this.canPlant = canPlant;
            return this;
        }

        @Info(value="Plant a seed at the given position and return the remaining seed stack. Mandatory. <br>\n\u5728\u6307\u5b9a\u4f4d\u7f6e\u79cd\u690d\u79cd\u5b50\uff0c\u5e76\u8fd4\u56de\u5269\u4f59\u7684\u79cd\u5b50\u7269\u54c1\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder plant(QuadFunction<EntityMaid, BlockPos, BlockState, ItemStack, ItemStack> plant) {
            this.plant = plant;
            return this;
        }

        @Info(value="The distance at which the maid considers herself close enough to the crop. <br>\nOnly when the distance to the target block is less than or equal to this value will the planting/harvesting logic be executed. <br>\nDefault is 2 blocks. <br>\n\u5973\u4ec6\u8ba4\u4e3a\u81ea\u5df1\u79bb\u4f5c\u7269\u8db3\u591f\u8fd1\u7684\u8ddd\u79bb\uff0c\u5f53\u8ddd\u79bb\u76ee\u6807\u65b9\u5757\u5c0f\u4e8e\u7b49\u4e8e\u6b64\u503c\u65f6\u624d\u4f1a\u6267\u884c\u79cd\u690d/\u6536\u5272\u903b\u8f91\uff0c\u9ed8\u8ba4\u4e3a 2 \u683c\u3002\n")
        public Builder closeEnoughDist(double closeEnoughDist) {
            this.closeEnoughDist = closeEnoughDist;
            return this;
        }

        @Info(value="Check if there are two blocks of space above the target position for the maid to reach. Default is true. <br>\n\u68c0\u67e5\u76ee\u6807\u4e0a\u9762\u662f\u5426\u6709\u4e24\u683c\u7a7a\u95f4\u80fd\u5bb9\u7eb3\u5973\u4ec6\u5230\u8fbe\uff0c\u9ed8\u8ba4\u4e3a true\u3002\n")
        public Builder checkCropPosAbove(boolean checkCropPosAbove) {
            this.checkCropPosAbove = checkCropPosAbove;
            return this;
        }
    }
}

