/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.AdvancementDataGen;
import com.github.tartaricacid.touhoulittlemaid.datagen.DataMapGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.GlobalLootModifier;
import com.github.tartaricacid.touhoulittlemaid.datagen.ItemModelGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.RecipeGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.RegistryDataGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.DamageTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.EntityTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagPaintingVariant;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagRecipeSerializer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="touhou_little_maid", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        DataGenerator.PackGenerator vanillaPack = generator.getVanillaPack(true);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput pack = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementDataGen(pack, registries, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(pack, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTableGenerator.ChestLootTables::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(LootTableGenerator.AdvancementLootTables::new, LootContextParamSets.ADVANCEMENT_REWARD), new LootTableProvider.SubProviderEntry(LootTableGenerator.EntityLootTables::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(LootTableGenerator.BlockLootTables::new, LootContextParamSets.BLOCK)), new RegistryDataGenerator(event.getGenerator().getPackOutput(), event.getLookupProvider()).getRegistryProvider()));
        vanillaPack.addProvider(packOutput -> new GlobalLootModifier(packOutput, registries, "touhou_little_maid"));
        vanillaPack.addProvider(packOutput -> new RecipeGenerator(packOutput, registries));
        TagBlock blockTagsProvider = (TagBlock)vanillaPack.addProvider(packOutput -> new TagBlock(packOutput, registries, "touhou_little_maid", existingFileHelper));
        vanillaPack.addProvider(packOutput -> new TagItem(packOutput, registries, blockTagsProvider.contentsGetter(), "touhou_little_maid", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeGenerator(pack, event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTypeGenerator(pack, event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new TagRecipeSerializer(pack, event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new TagPaintingVariant(pack, event.getLookupProvider(), event.getExistingFileHelper()));
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(pack, event.getLookupProvider());
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(pack, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(pack, registries));
    }
}

