/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.loot.LootTableTypeCondition;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public class GlobalLootModifier
extends GlobalLootModifierProvider {
    private static final ResourceLocation CHEST = ResourceLocation.withDefaultNamespace((String)"chest");
    private static final ResourceLocation FISHING = ResourceLocation.withDefaultNamespace((String)"fishing");

    public GlobalLootModifier(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String modId) {
        super(output, registries, modId);
    }

    public void start() {
        this.addAllChestLootModifier("chest_power_point", LootTableGenerator.CHEST_POWER_POINT);
        this.addChestLootModifier("spawn_bonus_chest", (ResourceKey<LootTable>)BuiltInLootTables.SPAWN_BONUS_CHEST, LootTableGenerator.SPAWN_BONUS);
        this.addChestLootModifier("village_temple", (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TEMPLE, LootTableGenerator.NORMAL_BAUBLE);
        this.addChestLootModifier("village_cartographer", (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_CARTOGRAPHER, LootTableGenerator.RANDOM_BOARD_STATE);
        this.addChestLootModifier("desert_pyramid", (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID, LootTableGenerator.RARE_BAUBLE);
        this.addChestLootModifier("jungle_temple", (ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE, LootTableGenerator.RARE_BAUBLE);
        this.addChestLootModifier("woodland_mansion_bauble", (ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION, LootTableGenerator.VERY_RARE_BAUBLE);
        this.addChestLootModifier("simple_dungeon", (ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON, LootTableGenerator.FURNACE_OR_CRAFTING_TABLE_BACKPACK);
        this.addChestLootModifier("abandoned_mineshaft", (ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT, LootTableGenerator.NORMAL_BACKPACK);
        this.addChestLootModifier("nether_bridge", (ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE, LootTableGenerator.TANK_BACKPACK);
        this.addChestLootModifier("stronghold_corridor", (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR, LootTableGenerator.ENDER_CHEST_BACKPACK);
        this.addChestLootModifier("stronghold_library", (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_LIBRARY, LootTableGenerator.SHRINE_LESS);
        this.addChestLootModifier("stronghold_library_board_state", (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_LIBRARY, LootTableGenerator.RANDOM_BOARD_STATE);
        this.addChestLootModifier("ancient_city", (ResourceKey<LootTable>)BuiltInLootTables.ANCIENT_CITY, LootTableGenerator.SHRINE_LESS);
        this.addChestLootModifier("bastion_treasure", (ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE, LootTableGenerator.SHRINE_LESS);
        this.addChestLootModifier("end_city_treasure", (ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE, LootTableGenerator.SHRINE_MORE);
        this.addChestLootModifier("maid_buried_treasure", (ResourceKey<LootTable>)BuiltInLootTables.BURIED_TREASURE, LootTableGenerator.MAID_BURIED_TREASURE);
        this.addChestLootModifier("pillager_outpost_gift", (ResourceKey<LootTable>)BuiltInLootTables.PILLAGER_OUTPOST, LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT);
        this.addChestLootModifier("woodland_mansion_gift", (ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION, LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT);
        this.addFishLootModifier("fishing_power_point", (ResourceKey<LootTable>)BuiltInLootTables.FISHING_JUNK, LootTableGenerator.FISHING_POWER_POINT);
    }

    private void addChestLootModifier(String name, @Nullable ResourceKey<LootTable> lootTableId, ResourceKey<LootTable> lootTableAdd) {
        LootTableTypeCondition condition = new LootTableTypeCondition(CHEST, lootTableId, lootTableAdd);
        this.add(name, (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{condition}, lootTableAdd), new ICondition[0]);
    }

    private void addAllChestLootModifier(String name, ResourceKey<LootTable> lootTableAdd) {
        this.addChestLootModifier(name, null, lootTableAdd);
    }

    private void addFishLootModifier(String name, @Nullable ResourceKey<LootTable> lootTableId, ResourceKey<LootTable> lootTableAdd) {
        LootTableTypeCondition condition = new LootTableTypeCondition(FISHING, lootTableId, lootTableAdd);
        this.add(name, (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{condition}, lootTableAdd), new ICondition[0]);
    }
}

