/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain;

import com.github.tartaricacid.touhoulittlemaid.api.entity.ai.IExtraMaidBrain;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ExtraMaidBrainManager;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ride.MaidRideBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAwaitTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBreathAirStopTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBreathAirTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearHurtTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearSleepTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClimbTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFindHomeMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFollowOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFollowOwnerVehicleTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidHealSelfTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidHomeMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidInteractWithDoor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidJoyTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPanicTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPickupEntitiesTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRunAwayTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRunOne;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSwimJumpTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUpdateActivityFromSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidWorkMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public final class MaidBrain {
    public static ImmutableList<MemoryModuleType<?>> getMemoryTypes() {
        ArrayList defaultTypes = Lists.newArrayList((Object[])new MemoryModuleType[]{MemoryModuleType.PATH, MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_HOSTILE, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.WALK_TARGET, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, InitEntities.TARGET_POS.get()});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> defaultTypes.addAll(extra.getExtraMemoryTypes()));
        return ImmutableList.copyOf((Collection)defaultTypes);
    }

    public static ImmutableList<SensorType<? extends Sensor<? super EntityMaid>>> getSensorTypes() {
        ArrayList defaultTypes = Lists.newArrayList((Object[])new SensorType[]{InitEntities.MAID_NEAREST_LIVING_ENTITY_SENSOR.get(), SensorType.HURT_BY, InitEntities.MAID_HOSTILES_SENSOR.get(), InitEntities.MAID_PICKUP_ENTITIES_SENSOR.get()});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> defaultTypes.addAll(extra.getExtraSensorTypes()));
        return ImmutableList.copyOf((Collection)defaultTypes);
    }

    public static void registerBrainGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        MaidBrain.registerSchedule(brain, maid);
        MaidBrain.registerCoreGoals(brain);
        MaidBrain.registerPanicGoals(brain);
        MaidBrain.registerRideIdleGoals(brain);
        MaidBrain.registerRideWorkGoals(brain, maid);
        MaidBrain.registerRideRestGoals(brain);
        MaidBrain.registerIdleGoals(brain);
        MaidBrain.registerWorkGoals(brain, maid);
        MaidBrain.registerRestGoals(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.setActiveActivityIfPossible(Activity.IDLE);
        MaidUpdateActivityFromSchedule.updateActivityFromSchedule(maid, brain);
    }

    private static void registerSchedule(Brain<EntityMaid> brain, EntityMaid maid) {
        switch (maid.getSchedule()) {
            case ALL: {
                brain.setSchedule(InitEntities.MAID_ALL_DAY_SCHEDULES.get());
                break;
            }
            case NIGHT: {
                brain.setSchedule(InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.get());
                break;
            }
            default: {
                brain.setSchedule(InitEntities.MAID_DAY_SHIFT_SCHEDULES.get());
            }
        }
    }

    private static void registerCoreGoals(Brain<EntityMaid> brain) {
        Pair swimJump = Pair.of((Object)0, (Object)((Object)new MaidSwimJumpTask(0.8f)));
        Pair breathAir = Pair.of((Object)0, (Object)((Object)new MaidBreathAirTask()));
        Pair breathAirStop = Pair.of((Object)0, (Object)((Object)new MaidBreathAirStopTask()));
        Pair climb = Pair.of((Object)0, (Object)((Object)new MaidClimbTask()));
        Pair look = Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90));
        Pair maidPanic = Pair.of((Object)1, (Object)((Object)new MaidPanicTask()));
        Pair maidAwait = Pair.of((Object)1, (Object)((Object)new MaidAwaitTask()));
        Pair interactWithDoor = Pair.of((Object)2, MaidInteractWithDoor.create());
        Pair walkToTarget = Pair.of((Object)2, (Object)new MoveToTargetSink());
        Pair followOwner = Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerTask(0.5f, 2)));
        Pair followOwnerVehicle = Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerVehicleTask(0.5f, 2)));
        Pair healSelf = Pair.of((Object)3, (Object)((Object)new MaidHealSelfTask()));
        Pair pickupItem = Pair.of((Object)10, (Object)((Object)new MaidPickupEntitiesTask(EntityMaid::isPickup, 0.6f)));
        Pair clearSleep = Pair.of((Object)99, (Object)((Object)new MaidClearSleepTask()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{swimJump, climb, breathAir, breathAirStop, look, maidPanic, maidAwait, interactWithDoor, walkToTarget, followOwner, followOwnerVehicle, healSelf, pickupItem, clearSleep});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getCoreBehaviors()));
        brain.addActivity(Activity.CORE, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerIdleGoals(Brain<EntityMaid> brain) {
        Pair beg = Pair.of((Object)5, (Object)((Object)new MaidBegTask()));
        Pair homeMeal = Pair.of((Object)6, (Object)((Object)new MaidFindHomeMealTask(0.6f, 2)));
        Pair joy = Pair.of((Object)7, (Object)((Object)new MaidJoyTask(0.6f, 2)));
        Pair supplemented = Pair.of((Object)20, (Object)((Object)MaidBrain.getLookAndRandomWalk(maid -> !maid.getSwimManager().isGoingToBreath())));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{beg, homeMeal, joy, supplemented, updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getIdleBehaviors()));
        brain.addActivity(Activity.IDLE, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerWorkGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        IMaidTask task = maid.getTask();
        ArrayList pairMaidList = task.createBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        } else {
            pairMaidList.add((Pair<Integer, BehaviorControl<? super EntityMaid>>)updateActivity);
        }
        pairMaidList.add(Pair.of((Object)6, (Object)((Object)new MaidBegTask())));
        pairMaidList.add(Pair.of((Object)7, (Object)((Object)new MaidWorkMealTask())));
        pairMaidList.add(Pair.of((Object)20, (Object)((Object)MaidBrain.getLookAndRandomWalk(e -> e.getTask().enableLookAndRandomWalk((EntityMaid)e) && !e.getSwimManager().isGoingToBreath()))));
        for (IExtraMaidBrain extra : ExtraMaidBrainManager.EXTRA_MAID_BRAINS) {
            pairMaidList.addAll(extra.getWorkBehaviors());
        }
        brain.addActivity(Activity.WORK, ImmutableList.copyOf((Collection)pairMaidList));
    }

    private static void registerRestGoals(Brain<EntityMaid> brain) {
        Pair bed = Pair.of((Object)5, (Object)((Object)new MaidBedTask(0.6f, 2)));
        Pair supplemented = Pair.of((Object)20, (Object)((Object)MaidBrain.getLookAndRandomWalk(maid -> true)));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{bed, supplemented, updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRestBehaviors()));
        brain.addActivity(Activity.REST, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerPanicGoals(Brain<EntityMaid> brain) {
        Pair clearHurt = Pair.of((Object)5, (Object)((Object)new MaidClearHurtTask()));
        Pair runAway = Pair.of((Object)5, MaidRunAwayTask.entity((MemoryModuleType<? extends Entity>)MemoryModuleType.NEAREST_HOSTILE, 0.7f, false));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{clearHurt, runAway});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getPanicBehaviors()));
        brain.addActivity(Activity.PANIC, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerRideIdleGoals(Brain<EntityMaid> brain) {
        Pair beg = Pair.of((Object)4, (Object)((Object)new MaidRideBegTask()));
        Pair homeMeal = Pair.of((Object)5, (Object)((Object)new MaidHomeMealTask()));
        Pair look = Pair.of((Object)6, (Object)((Object)MaidBrain.getLook(maid -> true)));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{beg, homeMeal, look, updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRideIdleBehaviors()));
        brain.addActivity(InitEntities.RIDE_IDLE.get(), ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerRideWorkGoals(Brain<EntityMaid> brain, EntityMaid maid) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        IMaidTask task = maid.getTask();
        ArrayList pairMaidList = task.createRideBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        } else {
            pairMaidList.add((Pair<Integer, BehaviorControl<? super EntityMaid>>)updateActivity);
        }
        pairMaidList.add(Pair.of((Object)6, (Object)((Object)new MaidRideBegTask())));
        pairMaidList.add(Pair.of((Object)7, (Object)((Object)new MaidWorkMealTask())));
        pairMaidList.add(Pair.of((Object)20, (Object)((Object)MaidBrain.getLook(e -> e.getTask().enableLookAndRandomWalk((EntityMaid)e)))));
        for (IExtraMaidBrain extra : ExtraMaidBrainManager.EXTRA_MAID_BRAINS) {
            pairMaidList.addAll(extra.getRideWorkBehaviors());
        }
        brain.addActivity(InitEntities.RIDE_WORK.get(), ImmutableList.copyOf((Collection)pairMaidList));
    }

    private static void registerRideRestGoals(Brain<EntityMaid> brain) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRideRestBehaviors()));
        brain.addActivity(InitEntities.RIDE_REST.get(), ImmutableList.copyOf((Collection)behaviors));
    }

    private static MaidRunOne getLookAndRandomWalk(Predicate<EntityMaid> enableCondition) {
        Pair lookToPlayer = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)SetEntityLookTarget.create(EntityMaid.TYPE, (float)5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.WOLF, (float)5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.CAT, (float)5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PARROT, (float)5.0f), (Object)1);
        Pair walkRandomly = Pair.of((Object)RandomStroll.stroll((float)0.3f, (int)5, (int)3), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        return new MaidRunOne((List<Pair<? extends BehaviorControl<? super EntityMaid>, Integer>>)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)walkRandomly, (Object)noLook), enableCondition);
    }

    private static MaidRunOne getLook(Predicate<EntityMaid> enableCondition) {
        Pair lookToPlayer = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)SetEntityLookTarget.create(EntityMaid.TYPE, (float)5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.WOLF, (float)5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.CAT, (float)5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PARROT, (float)5.0f), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        return new MaidRunOne((List<Pair<? extends BehaviorControl<? super EntityMaid>, Integer>>)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)noLook), enableCondition);
    }
}

