/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import org.jetbrains.annotations.Nullable;

public class MaidWalkToLivingEntityTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final Predicate<EntityMaid> startSearchPredicate;
    private final BiPredicate<EntityMaid, LivingEntity> entityPredicate;
    private final BiConsumer<EntityMaid, LivingEntity> arriveAction;
    private final float closeEnoughDistance;
    @Nullable
    private LivingEntity targetEntity = null;

    public MaidWalkToLivingEntityTask(float speedModifier, float closeEnoughDistance, @Nullable Predicate<EntityMaid> startSearchPredicate, @Nullable BiPredicate<EntityMaid, LivingEntity> entityPredicate, @Nullable BiConsumer<EntityMaid, LivingEntity> arriveAction) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(12);
        this.closeEnoughDistance = closeEnoughDistance;
        this.startSearchPredicate = Objects.requireNonNullElse(startSearchPredicate, maid -> false);
        this.entityPredicate = Objects.requireNonNullElse(entityPredicate, (maid, entity) -> false);
        this.arriveAction = Objects.requireNonNullElse(arriveAction, (maid, entity) -> {});
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.targetEntity = null;
        if (!this.startSearchPredicate.test(maid)) {
            return;
        }
        this.getEntities(maid).find(e -> maid.isWithinRestriction(e.blockPosition())).filter(Entity::isAlive).filter(e -> this.entityPredicate.test(maid, (LivingEntity)e)).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.targetEntity = e;
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)((int)Math.max(0.0f, this.closeEnoughDistance - 1.0f)));
        });
        if (this.targetEntity != null && this.targetEntity.closerThan((Entity)maid, (double)this.closeEnoughDistance)) {
            this.arriveAction.accept(maid, this.targetEntity);
            maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
            maid.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            this.targetEntity = null;
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
    }
}

