/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FairyAttackGoal
extends Goal {
    private static final int MAX_WITH_IN_RANGE_TIME = 20;
    private final EntityFairy entityFairy;
    private final double minDistance;
    private final double speedIn;
    private Path path;
    private int withInRangeTime;

    public FairyAttackGoal(EntityFairy entityFairy, double minDistance, double speedIn) {
        this.entityFairy = entityFairy;
        this.minDistance = minDistance;
        this.speedIn = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity target = this.entityFairy.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        this.path = this.entityFairy.getNavigation().createPath((Entity)target, 0);
        return this.path != null;
    }

    public void start() {
        this.entityFairy.getNavigation().moveTo(this.path, this.speedIn);
    }

    public void tick() {
        LivingEntity target = this.entityFairy.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        this.entityFairy.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        double distance = this.entityFairy.distanceTo((Entity)target);
        if (this.entityFairy.getSensing().hasLineOfSight((Entity)target) && distance >= this.minDistance) {
            this.entityFairy.getNavigation().moveTo((Entity)target, this.speedIn);
            this.withInRangeTime = 0;
        } else if (distance < this.minDistance) {
            this.entityFairy.getNavigation().stop();
            ++this.withInRangeTime;
            Vec3 motion = this.entityFairy.getDeltaMovement();
            this.entityFairy.setDeltaMovement(motion.x, 0.0, motion.z);
            this.entityFairy.setNoGravity(true);
            if (this.withInRangeTime > 20) {
                float percent = (float)(distance / this.minDistance);
                this.entityFairy.performRangedAttack(target, 1.0f - percent);
                this.withInRangeTime = 0;
            }
        } else {
            this.withInRangeTime = 0;
        }
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.entityFairy.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        boolean isPlayerAndCanNotBeAttacked = target instanceof Player && (target.isSpectator() || ((Player)target).isCreative());
        return !isPlayerAndCanNotBeAttacked;
    }

    public void stop() {
        boolean isPlayerAndCanNotBeAttacked;
        LivingEntity target = this.entityFairy.getTarget();
        boolean bl = isPlayerAndCanNotBeAttacked = target instanceof Player && (target.isSpectator() || ((Player)target).isCreative());
        if (isPlayerAndCanNotBeAttacked) {
            this.entityFairy.setTarget(null);
        }
        this.entityFairy.getNavigation().stop();
        this.withInRangeTime = 0;
    }
}

