/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.path;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugMaidManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaidWrappedPathFinder
extends PathFinder {
    protected Mob mob;

    public MaidWrappedPathFinder(NodeEvaluator nodeEvaluator, int maxVisitedNodes) {
        super(nodeEvaluator, maxVisitedNodes);
    }

    @Nullable
    public Path findPath(PathNavigationRegion region, Mob mob, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.mob = mob;
        return super.findPath(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
    }

    @Nullable
    public Path findPath(ProfilerFiller profiler, Node node, Map<Target, BlockPos> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        EntityMaid maid;
        Mob mob;
        if (TouhouLittleMaid.DEBUG && (mob = this.mob) instanceof EntityMaid && DebugMaidManager.getDebuggingPlayer(maid = (EntityMaid)mob) != null) {
            final ArrayList tmpClosedSet = Lists.newArrayList();
            this.openSet = new BinaryHeap(this){

                @NotNull
                public Node pop() {
                    Node pop = super.pop();
                    tmpClosedSet.add(pop);
                    return pop;
                }
            };
            Path path = super.findPath(profiler, node, targetPos, maxRange, accuracy, searchDepthMultiplier);
            if (path == null) {
                return null;
            }
            Node[] closedSet = tmpClosedSet.toArray(new Node[0]);
            Node[] openSet = new Node[this.openSet.size()];
            int idx = 0;
            while (!this.openSet.isEmpty()) {
                openSet[idx++] = this.openSet.pop();
            }
            path.setDebug(openSet, closedSet, targetPos.keySet());
            return path;
        }
        return super.findPath(profiler, node, targetPos, maxRange, accuracy, searchDepthMultiplier);
    }
}

