/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="touhou_little_maid")
public final class CopyEntityIdEvent {
    @SubscribeEvent
    public static void copyEntityId(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity target = event.getTarget();
        if (player.getItemInHand(hand).is((Item)InitItems.ENTITY_ID_COPY.get())) {
            if (player.level.isClientSide && FMLEnvironment.dist == Dist.CLIENT) {
                CopyEntityIdEvent.copyEntityId(player, target);
            }
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void copyEntityId(Player player, Entity target) {
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType());
        if (key == null) {
            return;
        }
        Minecraft.getInstance().keyboardHandler.setClipboard(key.toString());
        player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.entity_id_copy.copy", (Object[])new Object[]{key.toString()}));
    }
}

