/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event.maid;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public final class GetExpBottleEvent {
    private static final int PER_BOTTLE_XP = 12;

    @SubscribeEvent
    public static void onInteract(InteractMaidEvent event) {
        ItemStack itemstack = event.getStack();
        Player player = event.getPlayer();
        EntityMaid maid = event.getMaid();
        Level world = event.getWorld();
        if (itemstack.getItem() == Items.GLASS_BOTTLE) {
            int count = maid.getExperience() / 12;
            if (count <= 0) {
                return;
            }
            count = player.isDiscrete() ? Math.min(count, itemstack.getCount()) : 1;
            int costNum = 12 * count;
            maid.setExperience(maid.getExperience() - costNum);
            itemstack.shrink(count);
            if (!world.isClientSide) {
                ItemStack xpBottles = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, count);
                Containers.dropItemStack((Level)world, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)xpBottles);
            }
            maid.playSound(SoundEvents.ITEM_PICKUP, 0.2f, ((world.random.nextFloat() - world.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "take_maid_xp");
            }
            event.setCanceled(true);
        }
    }
}

