/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackGarageKitRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapDecoder;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ItemGarageKit
extends BlockItem {
    public static final IClientItemExtensions ITEM_EXTENSIONS = FMLEnvironment.dist == Dist.CLIENT ? new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            Minecraft minecraft = Minecraft.getInstance();
            return new TileEntityItemStackGarageKitRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels());
        }
    } : null;
    private static final String DEFAULT_ENTITY_ID = "touhou_little_maid:maid";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private static final CustomData DEFAULT_DATA = ItemGarageKit.getDefaultData();

    public ItemGarageKit() {
        super((Block)InitBlocks.GARAGE_KIT.get(), new Item.Properties().stacksTo(1));
    }

    public static CustomData getMaidData(ItemStack stack) {
        return Objects.requireNonNullElse((CustomData)stack.get(InitDataComponent.MAID_INFO), DEFAULT_DATA);
    }

    private static CustomData getDefaultData() {
        CompoundTag data = new CompoundTag();
        data.putString("id", DEFAULT_ENTITY_ID);
        data.putString("model_id", DEFAULT_MODEL_ID);
        data.putBoolean("IsYsmModel", false);
        return CustomData.of((CompoundTag)data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT && Minecraft.getInstance().level != null) {
            YsmMaidInfo ysmMaidInfo;
            MutableComponent prefix = Component.translatable((String)"block.touhou_little_maid.garage_kit.prefix");
            CustomData data = ItemGarageKit.getMaidData(stack);
            String entityId = data.read((MapDecoder)Codec.STRING.fieldOf("id")).result().orElse(DEFAULT_ENTITY_ID);
            if (!entityId.equals(DEFAULT_ENTITY_ID)) {
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityId));
                return prefix.append(entityType.getDescription());
            }
            if (YsmCompat.isInstalled() && (ysmMaidInfo = YsmCompat.getYsmMaidInfo(data.copyTag())).isYsmModel()) {
                MutableComponent name = Component.Serializer.fromJson((String)ysmMaidInfo.name(), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                if (name == null || name.equals((Object)Component.empty())) {
                    return prefix.append(ysmMaidInfo.modelId());
                }
                return prefix.append((Component)name);
            }
            String modelId = data.read((MapDecoder)Codec.STRING.fieldOf("model_id")).result().orElse(DEFAULT_MODEL_ID);
            MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).orElse(null);
            if (info != null) {
                return prefix.append((Component)ParseI18n.parse(info.getName()));
            }
            return super.getName(stack);
        }
        return super.getName(stack);
    }
}

