/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemMaidBeacon
extends DoubleHighBlockItem {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String NEO_FORGE_DATA_TAG = "NeoForgeData";

    public ItemMaidBeacon() {
        super((Block)InitBlocks.MAID_BEACON.get(), new Item.Properties().stacksTo(1).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.2f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public static ItemStack tileEntityToItemStack(HolderLookup.Provider provider, TileEntityMaidBeacon beacon) {
        ItemStack stack = ((Item)InitItems.MAID_BEACON.get()).getDefaultInstance();
        stack.set(InitDataComponent.STORAGE_DATA_TAG, (Object)beacon.saveWithoutMetadata(provider));
        return stack;
    }

    public static void itemStackToTileEntity(ItemStack stack, TileEntityMaidBeacon beacon) {
        CompoundTag tag = (CompoundTag)stack.get(InitDataComponent.STORAGE_DATA_TAG);
        if (tag != null && tag.contains(NEO_FORGE_DATA_TAG, 10)) {
            CompoundTag forgeTag = tag.getCompound(NEO_FORGE_DATA_TAG);
            beacon.loadData(forgeTag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag forgeTag;
        float numPower = 0.0f;
        CompoundTag tag = (CompoundTag)stack.get(InitDataComponent.STORAGE_DATA_TAG);
        if (tag != null && tag.contains(NEO_FORGE_DATA_TAG, 10) && (forgeTag = tag.getCompound(NEO_FORGE_DATA_TAG)).contains("StoragePower", 5)) {
            numPower = forgeTag.getFloat("StoragePower");
        }
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.maid_beacon.desc", (Object[])new Object[]{DECIMAL_FORMAT.format(numPower)}).withStyle(ChatFormatting.GRAY));
    }
}

