/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.HighLevelOggStreamPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.audio.OggAudioInfoHeader;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex.SpeexPacket;

public class SpeexInfo
extends HighLevelOggStreamPacket
implements SpeexPacket,
OggAudioInfoHeader {
    private String versionString;
    private int versionId;
    private long rate;
    private int mode;
    private int modeBitstreamVersion;
    private int channels;
    private int bitrate;
    private int frameSize;
    private int vbr;
    private int framesPerPacket;
    private int extraHeaders;
    private int reserved1;
    private int reserved2;

    public SpeexInfo() {
        this.versionString = "Gagravarr Ogg v0.8";
        this.versionId = 1;
    }

    public SpeexInfo(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        if (!IOUtils.byteRangeMatches(MAGIC_HEADER_BYTES, data, 0)) {
            throw new IllegalArgumentException("Invalid type, not a Speex Header");
        }
        this.versionString = IOUtils.removeNullPadding(IOUtils.getUTF8(data, 8, 20));
        this.versionId = (int)IOUtils.getInt4(data, 28);
        int headerSize = (int)IOUtils.getInt4(data, 32);
        if (headerSize != data.length) {
            throw new IllegalArgumentException("Invalid Speex Header, expected " + headerSize + " bytes, found " + data.length);
        }
        this.rate = IOUtils.getInt4(data, 36);
        this.mode = (int)IOUtils.getInt4(data, 40);
        this.modeBitstreamVersion = (int)IOUtils.getInt4(data, 44);
        this.channels = (int)IOUtils.getInt4(data, 48);
        this.bitrate = (int)IOUtils.getInt4(data, 52);
        this.frameSize = (int)IOUtils.getInt4(data, 56);
        this.vbr = (int)IOUtils.getInt4(data, 60);
        this.framesPerPacket = (int)IOUtils.getInt4(data, 64);
        this.extraHeaders = (int)IOUtils.getInt4(data, 68);
        this.reserved1 = (int)IOUtils.getInt4(data, 72);
        this.reserved2 = (int)IOUtils.getInt4(data, 76);
    }

    public OggPacket write() {
        byte[] data = new byte[80];
        System.arraycopy(MAGIC_HEADER_BYTES, 0, data, 0, 8);
        IOUtils.putUTF8(data, 8, this.versionString);
        IOUtils.putInt4(data, 28, this.versionId);
        IOUtils.putInt4(data, 32, data.length);
        IOUtils.putInt4(data, 36, this.rate);
        IOUtils.putInt4(data, 40, this.mode);
        IOUtils.putInt4(data, 44, this.modeBitstreamVersion);
        IOUtils.putInt4(data, 48, this.channels);
        IOUtils.putInt4(data, 52, this.bitrate);
        IOUtils.putInt4(data, 56, this.frameSize);
        IOUtils.putInt4(data, 60, this.vbr);
        IOUtils.putInt4(data, 64, this.framesPerPacket);
        IOUtils.putInt4(data, 68, this.extraHeaders);
        IOUtils.putInt4(data, 72, this.reserved1);
        IOUtils.putInt4(data, 76, this.reserved2);
        this.setData(data);
        return super.write();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String versionString) {
        if (versionString.length() > 20) {
            versionString = versionString.substring(0, 20);
        }
        this.versionString = versionString;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public void setVersionId(int versionId) {
        this.versionId = versionId;
    }

    public long getRate() {
        return this.rate;
    }

    public int getSampleRate() {
        return (int)this.rate;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getModeBitstreamVersion() {
        return this.modeBitstreamVersion;
    }

    public void setModeBitstreamVersion(int modeBitstreamVersion) {
        this.modeBitstreamVersion = modeBitstreamVersion;
    }

    public int getNumChannels() {
        return this.channels;
    }

    public void setNumChannels(int channels) {
        this.channels = channels;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getPreSkip() {
        return 0;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public int getVbr() {
        return this.vbr;
    }

    public void setVbr(int vbr) {
        this.vbr = vbr;
    }

    public int getFramesPerPacket() {
        return this.framesPerPacket;
    }

    public void setFramesPerPacket(int framesPerPacket) {
        this.framesPerPacket = framesPerPacket;
    }

    public int getExtraHeaders() {
        return this.extraHeaders;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public int getReserved2() {
        return this.reserved2;
    }
}

