/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class SetTankCountFunction
extends LootItemConditionalFunction {
    public static MapCodec<SetTankCountFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetTankCountFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)ResourceLocation.CODEC.fieldOf("fluid_id").forGetter(f -> f.fluidId), (App)Codec.INT.fieldOf("count").forGetter(f -> f.count))).apply((Applicative)instance, SetTankCountFunction::new));
    private final ResourceLocation fluidId;
    private final int count;

    public SetTankCountFunction(List<LootItemCondition> predicates, ResourceLocation fluidId, int count) {
        super(predicates);
        this.fluidId = fluidId;
        this.count = count;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return InitLootModifier.SET_TANK_COUNT_FUNCTION.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        CompoundTag tags = (CompoundTag)stack.get(InitDataComponent.TANK_BACKPACK_TAG);
        if (tags == null) {
            tags = new CompoundTag();
        }
        FluidTank tank = new FluidTank(10000);
        FluidStack fluidStack = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(this.fluidId), this.count);
        tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        tank.writeToNBT((HolderLookup.Provider)context.getLevel().registryAccess(), tags);
        stack.set(InitDataComponent.TANK_BACKPACK_TAG, (Object)tags);
        return stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Fluid fluid;
        private final int bucketCount;

        public Builder(Fluid fluid, int bucketCount) {
            this.fluid = fluid;
            this.bucketCount = bucketCount;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            ResourceLocation key = BuiltInRegistries.FLUID.getKey((Object)this.fluid);
            return new SetTankCountFunction(this.getConditions(), key, this.bucketCount * 1000);
        }
    }
}

