/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTaskEnableEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MaidTaskPackage(int id, ResourceLocation uid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MaidTaskPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("maid_task"));
    public static final StreamCodec<ByteBuf, MaidTaskPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MaidTaskPackage::id, (StreamCodec)ResourceLocation.STREAM_CODEC, MaidTaskPackage::uid, MaidTaskPackage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(MaidTaskPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                    LivingEntity patt0$temp;
                    IMaidTask task = TaskManager.findTask(message.uid).orElse(TaskManager.getIdleTask());
                    if (task != TaskManager.getIdleTask() && ((MaidTaskEnableEvent)NeoForge.EVENT_BUS.post((Event)new MaidTaskEnableEvent(task, maid))).isCanceled()) {
                        return;
                    }
                    if (!task.isEnable(maid)) {
                        return;
                    }
                    maid.setTask(task);
                    if (!TaskManager.getIdleTask().equals(task) && (patt0$temp = maid.getOwner()) instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        ((MaidEventTrigger)((Object)((Object)InitTrigger.MAID_EVENT.get()))).trigger(serverPlayer, "switch_task");
                    }
                    if (sender.containerMenu instanceof TaskConfigContainer) {
                        maid.openMaidGui((Player)sender, 1);
                    }
                }
            });
        }
    }
}

