/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SendNameTagPackage(int id, String name, boolean alwaysShow) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendNameTagPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("send_name_tag"));
    public static final StreamCodec<ByteBuf, SendNameTagPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SendNameTagPackage::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, SendNameTagPackage::name, (StreamCodec)ByteBufCodecs.BOOL, SendNameTagPackage::alwaysShow, SendNameTagPackage::new);

    public static void handle(SendNameTagPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.id);
                if (entity instanceof EntityMaid) {
                    SendNameTagPackage.setMaidNameTag(message, sender, (EntityMaid)entity);
                }
            });
        }
    }

    private static void setMaidNameTag(SendNameTagPackage message, ServerPlayer player, EntityMaid maid) {
        String name = message.name.substring(0, Math.min(32, message.name.length()));
        if (player.equals((Object)maid.getOwner()) && player.getMainHandItem().getItem() == Items.NAME_TAG) {
            maid.setCustomName((Component)Component.literal((String)name));
            maid.setCustomNameVisible(message.alwaysShow);
            maid.setPersistenceRequired();
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

