/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ToggleTabPackage(int entityId, int tabId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleTabPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("toggle_tab"));
    public static final StreamCodec<ByteBuf, ToggleTabPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ToggleTabPackage::entityId, (StreamCodec)ByteBufCodecs.VAR_INT, ToggleTabPackage::tabId, ToggleTabPackage::new);

    public static void handle(ToggleTabPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                    maid.openMaidGui((Player)sender, message.tabId);
                }
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

