/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record WirelessIOSlotConfigPackage(List<Boolean> configData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WirelessIOSlotConfigPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("wireless_slot_config"));
    public static final StreamCodec<ByteBuf, WirelessIOSlotConfigPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL.apply(ByteBufCodecs.list()), WirelessIOSlotConfigPackage::configData, WirelessIOSlotConfigPackage::new);
    private static final List<Boolean> EMPTY = new ArrayList<Boolean>();

    public WirelessIOSlotConfigPackage() {
        this(EMPTY);
    }

    public static void handle(WirelessIOSlotConfigPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = (ServerPlayer)context.player();
                ItemStack handItem = sender.getMainHandItem();
                if (handItem.getItem() == InitItems.WIRELESS_IO.get()) {
                    if (!message.configData.isEmpty()) {
                        ItemWirelessIO.setSlotConfig(handItem, message.configData);
                    }
                    sender.openMenu((MenuProvider)((ItemWirelessIO)handItem.getItem()), buffer -> ItemStack.STREAM_CODEC.encode(buffer, (Object)handItem));
                }
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

