/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public final class JERIUtil {
    public static void recipeWarpHolder(List<RecipeHolder<AltarRecipe>> altarRecipes, AltarRecipeMaker maker) {
        for (RecipeHolder<AltarRecipe> altarRecipeHolder : altarRecipes) {
            AltarRecipe altarRecipe = (AltarRecipe)altarRecipeHolder.value();
            JERIUtil.recipeMaker(maker, altarRecipe);
        }
    }

    public static void recipeWarp(List<AltarRecipe> altarRecipes, AltarRecipeMaker maker) {
        for (AltarRecipe altarRecipeHolder : altarRecipes) {
            JERIUtil.recipeMaker(maker, altarRecipeHolder);
        }
    }

    private static void recipeMaker(AltarRecipeMaker maker, AltarRecipe altarRecipe) {
        Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)InitRecipes.ALTAR_CRAFTING.get());
        ResourceLocation recipeId = altarRecipe.getId();
        ItemStack output = altarRecipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        if (!altarRecipe.isItemCraft()) {
            output = ((Item)InitItems.ENTITY_PLACEHOLDER.get()).getDefaultInstance();
            ItemEntityPlaceholder.setRecipeId(output, altarRecipe.getRecipeString());
        }
        maker.accept(recipeId, (NonNullList<Ingredient>)altarRecipe.getIngredients(), output, altarRecipe.getPower(), altarRecipe.getLangKey());
    }

    public static interface AltarRecipeMaker {
        public void accept(ResourceLocation var1, NonNullList<Ingredient> var2, ItemStack var3, float var4, String var5);
    }
}

