/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class MaidRayTraceHelper {
    private MaidRayTraceHelper() {
    }

    public static Optional<EntityMaid> rayTraceMaid(Player player, double distance) {
        List maidList = player.level.getEntities((Entity)player, player.getBoundingBox().inflate(distance, distance, distance), entity -> entity instanceof EntityMaid && ((EntityMaid)entity).isOwnedBy((LivingEntity)player));
        for (Entity maid : maidList) {
            if (!maid.isAlive() || !(maid instanceof EntityMaid) || !MaidRayTraceHelper.isEntityBeLooked(player, maid) || !((EntityMaid)maid).isOwnedBy((LivingEntity)player)) continue;
            return Optional.of((EntityMaid)maid);
        }
        return Optional.empty();
    }

    private static boolean isEntityBeLooked(Player player, Entity lookEntity) {
        double maxDistanceDeviation;
        Vec3 lookVec = player.getLookAngle().normalize();
        Vec3 playerAndEntityVec = new Vec3(lookEntity.getX() - player.getX(), lookEntity.getBoundingBox().minY + (double)lookEntity.getEyeHeight() * 2.0 / 3.0 - (player.getY() + (double)player.getEyeHeight()), lookEntity.getZ() - player.getZ());
        double playerAndEntityDistance = playerAndEntityVec.length();
        double cosAngle = lookVec.dot(playerAndEntityVec = playerAndEntityVec.normalize());
        return cosAngle > 1.0 - (maxDistanceDeviation = 0.075 / playerAndEntityDistance) && player.hasLineOfSight(lookEntity);
    }
}

