/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.ChatClientInfo;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatPackage;
import java.net.http.HttpRequest;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class STTCallback
implements ResponseCallback<String> {
    private final Player player;
    private final EntityMaid maid;

    public STTCallback(Player player, EntityMaid maid) {
        this.player = player;
        this.maid = maid;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
        String cause = throwable.getLocalizedMessage();
        MutableComponent errorMessage = ErrorCode.getErrorMessage(ServiceType.STT, errorCode, cause);
        this.player.sendSystemMessage((Component)errorMessage.withStyle(ChatFormatting.RED));
        TouhouLittleMaid.LOGGER.error("STT request failed: {}, error is {}", (Object)request, (Object)throwable.getMessage());
    }

    @Override
    public void onSuccess(String chatText) {
        if (StringUtils.isNotBlank((CharSequence)chatText)) {
            ChatClientInfo clientInfo = ChatClientInfo.fromMaid(this.maid);
            PacketDistributor.sendToServer((CustomPacketPayload)new SendUserChatPackage(this.maid.getId(), chatText, clientInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            String name = this.player.getScoreboardName();
            String format = String.format("<%s> %s", name, chatText);
            this.player.sendSystemMessage((Component)Component.literal((String)format).withStyle(ChatFormatting.GRAY));
        } else {
            MutableComponent component = Component.translatable((String)"ai.touhou_little_maid.chat.stt.content_is_empty");
            this.player.sendSystemMessage((Component)component.withStyle(ChatFormatting.GRAY));
        }
    }
}

