/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ConditionArmor {
    private static final Pattern ID_PRE_REG = Pattern.compile("^(.+?)\\$(.*?)$");
    private static final Pattern TAG_PRE_REG = Pattern.compile("^(.+?)#(.*?)$");
    private static final String EMPTY = "";
    private final Map<EquipmentSlot, List<ResourceLocation>> idTest = Maps.newHashMap();
    private final Map<EquipmentSlot, List<TagKey<Item>>> tagTest = Maps.newHashMap();

    public void addTest(String name) {
        Matcher matcherId = ID_PRE_REG.matcher(name);
        if (matcherId.find()) {
            EquipmentSlot type = ConditionArmor.getType(matcherId.group(1));
            if (type == null) {
                return;
            }
            String id = matcherId.group(2);
            if (!ResourceLocationUtil.isValidResourceLocation(id)) {
                return;
            }
            ResourceLocation res = ResourceLocation.parse((String)id);
            if (this.idTest.containsKey(type)) {
                this.idTest.get(type).add(res);
            } else {
                this.idTest.put(type, Lists.newArrayList((Object[])new ResourceLocation[]{res}));
            }
            return;
        }
        Matcher matcherTag = TAG_PRE_REG.matcher(name);
        if (matcherTag.find()) {
            EquipmentSlot type = ConditionArmor.getType(matcherTag.group(1));
            if (type == null) {
                return;
            }
            String id = matcherTag.group(2);
            if (!ResourceLocationUtil.isValidResourceLocation(id)) {
                return;
            }
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)id));
            if (this.tagTest.containsKey(type)) {
                this.tagTest.get(type).add((TagKey<Item>)tagKey);
            } else {
                this.tagTest.put(type, Lists.newArrayList((Object[])new TagKey[]{tagKey}));
            }
        }
    }

    public String doTest(IMaid maid, EquipmentSlot slot) {
        ItemStack item = maid.asEntity().getItemBySlot(slot);
        if (item.isEmpty()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, slot);
        if (result.isEmpty()) {
            return this.doTagTest(maid, slot);
        }
        return result;
    }

    private String doIdTest(IMaid maid, EquipmentSlot slot) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.idTest.containsKey(slot) || this.idTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<ResourceLocation> idListTest = this.idTest.get(slot);
        ItemStack item = maid.asEntity().getItemBySlot(slot);
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
        if (registryName == null) {
            return EMPTY;
        }
        if (idListTest.contains(registryName)) {
            return slot.getName() + "$" + String.valueOf(registryName);
        }
        return EMPTY;
    }

    private String doTagTest(IMaid maid, EquipmentSlot slot) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.tagTest.containsKey(slot) || this.tagTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<TagKey<Item>> tagListTest = this.tagTest.get(slot);
        ItemStack item = maid.asEntity().getItemBySlot(slot);
        return tagListTest.stream().filter(arg_0 -> ((ItemStack)item).is(arg_0)).findFirst().map(itemTagKey -> slot.getName() + "#" + String.valueOf(itemTagKey.location())).orElse(EMPTY);
    }

    @Nullable
    public static EquipmentSlot getType(String type) {
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            if (!equipmentslot.getName().equals(type)) continue;
            return equipmentslot;
        }
        return null;
    }
}

