/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BeaconEffectButton;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconOverflowPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.StorageAndTakePowerPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.mojang.blaze3d.platform.InputConstants;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class MaidBeaconGui
extends Screen {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_beacon.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final TileEntityMaidBeacon beacon;
    protected int imageWidth = 300;
    protected int imageHeight = 113;
    protected int leftPos;
    protected int topPos;
    private boolean overflowDelete;
    private int potionIndex;

    public MaidBeaconGui(TileEntityMaidBeacon beacon) {
        super((Component)Component.literal((String)"Maid Beacon GUI"));
        this.beacon = beacon;
        this.overflowDelete = beacon.isOverflowDelete();
        this.potionIndex = beacon.getPotionIndex();
    }

    protected void init() {
        this.clearWidgets();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.addEffectButton(this.leftPos + 146, 26, this.topPos + 19);
        this.addStorageAndTakeButton();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getOverflowDeleteButtonText(this.overflowDelete), b -> {
            this.overflowDelete = !this.overflowDelete;
            PacketDistributor.sendToServer((CustomPacketPayload)new SetBeaconOverflowPackage(this.beacon.getBlockPos(), this.overflowDelete), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.init();
        }).pos(this.leftPos + 118, this.topPos + 94).size(154, 20).build());
    }

    private void addStorageAndTakeButton() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.touhou_little_maid.maid_beacon.add_one"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new StorageAndTakePowerPackage(this.beacon.getBlockPos(), 1.0f, true), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos + 118, this.topPos + 72).size(76, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.touhou_little_maid.maid_beacon.min_one"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new StorageAndTakePowerPackage(this.beacon.getBlockPos(), 1.0f, false), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos + 196, this.topPos + 72).size(76, 20).build());
    }

    private void addEffectButton(int start, int spacing, int y) {
        this.addRenderableWidget((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.SPEED, start, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.SPEED.ordinal() : -1;
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE, start + spacing, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE.ordinal() : -1;
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.STRENGTH, start + spacing * 2, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.STRENGTH.ordinal() : -1;
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.RESISTANCE, start + spacing * 3, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.RESISTANCE.ordinal() : -1;
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.REGENERATION, start + spacing * 4, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.REGENERATION.ordinal() : -1;
            this.init();
        }));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(BG, this.leftPos, this.topPos + 2, 0, 0, 142, 111);
        graphics.blit(BG, this.leftPos + 118, this.topPos + 1, 44, 111, 154, 15);
        graphics.blit(BG, this.leftPos + 224, this.topPos + 44, 44, 126, 12, 12);
        graphics.blit(BG, this.leftPos + 224, this.topPos + 58, 44, 138, 12, 12);
        graphics.blit(BG, this.leftPos + 146, this.topPos + 46, 58, 128, 74, 9);
        graphics.blit(BG, this.leftPos + 146, this.topPos + 59, 58, 128, 74, 9);
        float percent = this.beacon.getStoragePower() / this.beacon.getMaxStorage();
        graphics.blit(BG, this.leftPos + 146, this.topPos + 48, 58, 138, (int)(74.0f * percent), 5);
        this.renderPlayerPower(graphics);
        graphics.drawString(this.font, DECIMAL_FORMAT.format(this.beacon.getStoragePower()), this.leftPos + 240, this.topPos + 46, 0xFFFFFF);
        if (this.potionIndex == -1) {
            this.drawCenteredString(graphics, this.font, I18n.get((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(0L)}), this.leftPos + 195, this.topPos + 5, (int)ChatFormatting.DARK_GRAY.getColor());
        } else {
            this.drawCenteredString(graphics, this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(this.beacon.getEffectCost() * 900.0f)}).withStyle(ChatFormatting.RED), this.leftPos + 195, this.topPos + 5, 0xFFFFFF);
        }
        this.renderables.stream().filter(b -> b instanceof BeaconEffectButton).forEach(b -> ((BeaconEffectButton)((Object)b)).renderToolTip(graphics, this, mouseX, mouseY));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft != null && this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void renderPlayerPower(GuiGraphics graphics) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            PowerAttachment power = (PowerAttachment)player.getData(InitDataAttachment.POWER_NUM);
            float percent = power.get() / 5.0f;
            graphics.blit(BG, this.leftPos + 146, this.topPos + 61, 58, 143, (int)(74.0f * percent), 5);
            graphics.drawString(this.font, DECIMAL_FORMAT.format(power.get()), this.leftPos + 240, this.topPos + 60, 0xFFFFFF);
        }
    }

    private MutableComponent getOverflowDeleteButtonText(boolean overflowDelete) {
        return overflowDelete ? Component.translatable((String)"gui.touhou_little_maid.maid_beacon.overflow_delete_true") : Component.translatable((String)"gui.touhou_little_maid.maid_beacon.overflow_delete_false");
    }

    private void drawCenteredString(GuiGraphics graphics, Font font, String text, int pX, int pY, int color) {
        graphics.drawString(font, text, pX - font.width(text) / 2, pY, color, false);
    }

    private void drawCenteredString(GuiGraphics graphics, Font font, Component text, int pX, int pY, int color) {
        graphics.drawString(font, text, pX - font.width((FormattedText)text) / 2, pY, color, false);
    }
}

