/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import com.github.tartaricacid.touhoulittlemaid.api.event.client.OpenPatchouliBookEvent;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.mod.PatchouliWarningScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidSideTabButton;
import com.github.tartaricacid.touhoulittlemaid.compat.cloth.ClothConfigCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SideTab;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.common.NeoForge;

public class MaidSideTabs<T extends AbstractMaidContainer> {
    private static final int SPACING = 25;
    private final int entityId;
    private final int rightPos;
    private final int topPos;

    public MaidSideTabs(int entityId, int rightPos, int topPos) {
        this.entityId = entityId;
        this.rightPos = rightPos;
        this.topPos = topPos;
    }

    public MaidSideTabButton[] getTabs(AbstractMaidContainerGui<T> screen) {
        MaidSideTabButton taskBook = this.genSideTabButton(SideTab.TASK_BOOK, b -> {
            if (ModList.get().isLoaded("patchouli")) {
                EntityMaid maid = screen.getMaid();
                if (maid != null) {
                    NeoForge.EVENT_BUS.post((Event)new OpenPatchouliBookEvent(maid, maid.getTask()));
                }
            } else {
                PatchouliWarningScreen.open();
            }
        });
        MaidSideTabButton globalConfig = this.genSideTabButton(SideTab.GLOBAL_CONFIG, b -> {
            if (ModList.get().isLoaded("cloth_config")) {
                ClothConfigCompat.openConfigScreen();
            } else {
                ModList.get().getModContainerById("touhou_little_maid").ifPresent(modContainer -> {
                    Screen parent = Minecraft.getInstance().screen;
                    if (parent != null) {
                        Minecraft.getInstance().setScreen((Screen)new ConfigurationScreen(modContainer, parent));
                    }
                });
            }
        });
        return new MaidSideTabButton[]{taskBook, globalConfig};
    }

    private MaidSideTabButton genSideTabButton(SideTab sideTab, Button.OnPress onPressIn) {
        String name = sideTab.name().toLowerCase(Locale.ENGLISH);
        String titleLangKey = String.format("gui.touhou_little_maid.button.%s", name);
        String descLangKey = String.format("gui.touhou_little_maid.button.%s.desc", name);
        return new MaidSideTabButton(this.rightPos, this.topPos + sideTab.getIndex() * 25, sideTab.getIndex() * 25, onPressIn, List.of(Component.translatable((String)titleLangKey), Component.translatable((String)descLangKey)));
    }
}

