/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.HistoryChatWidget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.ClearMaidAIDataPacket;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiPackage;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class HistoryAIChatScreen
extends Screen {
    private final EntityMaid maid;
    private final ResourceLocation playerSkin;
    private final List<LLMMessage> history = Lists.newArrayList();
    private final List<Renderable> historyWidgets = Lists.newArrayList();
    private double scroll = 0.0;
    private int maxHeight = 0;
    private int posX = 0;

    public HistoryAIChatScreen(EntityMaid maid) {
        super((Component)Component.literal((String)"Maid History AI Chat Screen"));
        this.maid = maid;
        this.playerSkin = this.getPlayerSkin();
        this.transformMessage();
    }

    protected void init() {
        this.clearWidgets();
        this.historyWidgets.clear();
        this.posX = this.width / 2 - 75;
        this.maxHeight = 10;
        for (LLMMessage message : this.history) {
            int lineHeight = this.addHistoryWidget(message, this.posX);
            this.maxHeight += lineHeight + 5;
        }
        this.addButtons();
        if (this.maxHeight < this.height) {
            this.scroll = (double)(this.height - this.maxHeight) / 2.0;
        } else {
            double topMax = (double)this.height / 2.0 - 100.0;
            double bottomMax = (double)this.height / 2.0 + 100.0;
            double scrollBottom = this.scroll + (double)this.maxHeight;
            if (this.scroll > topMax) {
                this.scroll = topMax;
            }
            if (bottomMax > scrollBottom) {
                this.scroll = bottomMax - (double)this.maxHeight;
            }
        }
    }

    private void addButtons() {
        MutableComponent clearName = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat");
        MutableComponent clearMsg = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat.confirm");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)clearName, button -> this.getMinecraft().setScreen((Screen)new ConfirmScreen(yes -> {
            if (yes) {
                this.history.clear();
                this.historyWidgets.clear();
                this.maid.getAiChatManager().getHistory().getDeque().clear();
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearMaidAIDataPacket(this.maid.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.getMinecraft().setScreen((Screen)this);
        }, (Component)clearName, (Component)clearMsg))).bounds(this.posX + 150, this.height / 2 - 20, 120, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> {
            OpenMaidGuiPackage message = new OpenMaidGuiPackage(this.maid.getId(), 3);
            PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).bounds(this.posX + 150, this.height / 2 + 5, 120, 20).build());
    }

    private int addHistoryWidget(LLMMessage message, int posX) {
        boolean isLeft = message.role() != Role.USER;
        MutableComponent msg = Component.literal((String)message.message());
        int width = Math.min(this.font.width((FormattedText)msg), 140) + 10;
        int n = this.font.split((FormattedText)msg, 140).size();
        Objects.requireNonNull(this.font);
        int lineHeight = 10 + n * 9;
        if (isLeft) {
            this.historyWidgets.add((Renderable)new HistoryChatWidget(posX - 100, this.maxHeight, width, lineHeight, (Component)msg, this.playerSkin, message.gameTime(), true));
        } else {
            this.historyWidgets.add((Renderable)new HistoryChatWidget(posX + 100 - width, this.maxHeight, width, lineHeight, (Component)msg, this.playerSkin, message.gameTime(), false));
        }
        return lineHeight;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        MutableComponent title = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.title");
        graphics.drawCenteredString(this.font, (Component)title, this.posX + 210, this.height / 2 - 35, 0xFFFFFF);
        if (this.historyWidgets.isEmpty()) {
            MutableComponent empty = Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat_is_empty");
            List split = this.font.split((FormattedText)empty, 150);
            for (int i = 0; i < split.size(); ++i) {
                Objects.requireNonNull(this.font);
                int height = i * 9;
                graphics.drawCenteredString(this.font, (FormattedCharSequence)split.get(i), this.posX, this.height / 2 - 10 + height, 0xFF5555);
            }
        } else {
            graphics.enableScissor(this.posX - 128, 5, this.posX + 128, this.height - 5);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, this.scroll, 0.0);
            for (Renderable renderable : this.historyWidgets) {
                renderable.render(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.pose().popPose();
            graphics.disableScissor();
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            double topMax = (double)this.height / 2.0 - 100.0;
            double bottomMax = (double)this.height / 2.0 + 100.0;
            double scrollBottom = this.scroll + (double)this.maxHeight;
            if (scrollY < 0.0 && bottomMax < scrollBottom) {
                this.scroll += scrollY * 15.0;
            }
            if (0.0 < scrollY && this.scroll < topMax) {
                this.scroll += scrollY * 15.0;
            }
        }
        return super.mouseScrolled(pMouseX, pMouseY, scrollX, scrollY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void transformMessage() {
        LinkedBlockingDeque<LLMMessage> deque = this.maid.getAiChatManager().getHistory().getDeque();
        deque.descendingIterator().forEachRemaining(message -> {
            if (message.role() == Role.USER) {
                this.history.add((LLMMessage)message);
            } else if (message.role() == Role.ASSISTANT && StringUtils.isNotBlank((CharSequence)message.message())) {
                ResponseChat responseChat = new ResponseChat(message.message());
                this.history.add(new LLMMessage(Role.ASSISTANT, responseChat.getChatText(), message.gameTime(), null, null));
            }
        });
    }

    private ResourceLocation getPlayerSkin() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return DefaultPlayerSkin.getDefaultTexture();
        }
        return mc.getSkinManager().getInsecureSkin(player.getGameProfile()).texture();
    }
}

