/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.SkinGuiNumber;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractModelGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    public static final Button.OnPress NO_PRESS = b -> {};
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/skin_select.png");
    private static final ResourceLocation SIDE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/skin_select_side.png");
    private static final ResourceLocation EMPTY_ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/empty_model_pack_icon.png");
    private static final SimpleTexture EMPTY_ICON_TEXTURE = new SimpleTexture(EMPTY_ICON);
    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;
    private EditBox searchBox;
    private String searchText = "";
    private List<E> filteredModelList = null;
    private boolean isSearchMode = false;
    private List<E> allModelsList = null;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super((Component)Component.literal((String)"Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber(this.modelPackList);
        this.setPageIndex(Mth.clamp((int)this.getPageIndex(), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
        this.setPackIndex(Mth.clamp((int)this.getPackIndex(), (int)0, (int)(this.guiNumber.getPackSize() - 1)));
        this.setRowIndex(Mth.clamp((int)this.getRowIndex(), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex())));
        this.allModelsList = Lists.newArrayList();
        for (CustomModelPack<E> pack : this.modelPackList) {
            this.allModelsList.addAll(pack.getModelList());
        }
    }

    protected abstract void drawLeftEntity(GuiGraphics var1, int var2, int var3, float var4, float var5);

    protected abstract void drawRightEntity(GuiGraphics var1, int var2, int var3, E var4);

    protected abstract void openDetailsGui(T var1, E var2);

    protected abstract void notifyModelChange(T var1, E var2);

    protected abstract void addModelCustomTips(E var1, List<Component> var2);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int var1);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int var1);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int var1);

    public void init() {
        this.clearWidgets();
        this.updateFilteredModelList();
        int startX = this.width / 2 + 50;
        int startY = this.height / 2;
        for (int index = 0; index < 7; ++index) {
            this.addTabButton(startX, startY, index);
        }
        this.addRenderableWidget((GuiEventListener)new TouhouImageButton(startX + 122, startY - 97, 21, 17, 58, 201, 18, BG, b -> this.onClickCloseButton()));
        this.addPageButton(startX, startY);
        this.addModelButton(startX, startY);
        this.addScrollButton(startX, startY);
        MutableComponent enableCache = Component.translatable((String)"gui.touhou_little_maid.skin.enable_cache");
        int checkBoxWidth = this.font.width((FormattedText)enableCache) + 20;
        int xOffset = (startX - 128) / 2 - checkBoxWidth / 2;
        Checkbox cacheCheckBox = Checkbox.builder((Component)enableCache, (Font)this.font).pos(xOffset, startY - 101).selected(((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue()).onValueChange((checkBox, value) -> MiscConfig.MODEL_ICON_CACHE.set((Object)value)).build();
        this.addRenderableWidget((GuiEventListener)cacheCheckBox);
        int searchBoxWidth = 216;
        int searchBoxX = startX - 96;
        int searchBoxY = startY + 101;
        this.searchBox = new EditBox(this.font, searchBoxX, searchBoxY, searchBoxWidth, 18, (Component)Component.translatable((String)"gui.touhou_little_maid.skin.search"));
        this.searchBox.setMaxLength(48);
        this.searchBox.setBordered(true);
        this.searchBox.setTextColor(-1);
        this.searchBox.setValue(this.searchText);
        this.searchBox.setHint((Component)Component.translatable((String)"gui.touhou_little_maid.skin.search.hint").withStyle(ChatFormatting.DARK_GRAY));
        this.searchBox.setResponder(this::onSearchTextChanged);
        this.searchBox.setVisible(this.isSearchMode);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addSearchTabButton(startX, startY);
    }

    private void addModelButton(int startX, int startY) {
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex >= displayList.size()) {
            return;
        }
        int toIndex = Math.min(fromIndex + 55, displayList.size());
        for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
            this.addRenderableWidget((GuiEventListener)new TouhouImageButton(startX + offsetX - 8, startY + offsetY - 26, 15, 24, 41, 201, 24, BG, this.onModelButtonClick(modelItem)));
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void addScrollButton(int startX, int startY) {
        TouhouImageButton upButton = new TouhouImageButton(startX - 128 + 253, startY - 73, 14, 10, 24, 15, 10, SIDE, b -> {
            int row = Mth.clamp((int)(this.getRowIndex() - 1), (int)0, (int)this.getDisplayRowSize());
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.init();
            }
        });
        TouhouImageButton downButton = new TouhouImageButton(startX - 128 + 253, startY - 73 + 156, 14, 10, 38, 15, 10, SIDE, b -> {
            int row = Mth.clamp((int)(this.getRowIndex() + 1), (int)0, (int)this.getDisplayRowSize());
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.init();
            }
        });
        this.addRenderableWidget((GuiEventListener)upButton);
        this.addRenderableWidget((GuiEventListener)downButton);
    }

    private Button.OnPress onModelButtonClick(E modelItem) {
        return button -> {
            if (AbstractModelGui.hasShiftDown()) {
                this.openDetailsGui(this.entity, modelItem);
            } else {
                this.notifyModelChange(this.entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        Button prePage = Button.builder((Component)Component.literal((String)"<"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(Mth.clamp((int)(this.getPageIndex() - 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.init();
        }).pos(startX - 119, startY - 101).size(20, 20).build();
        Button nextPage = Button.builder((Component)Component.literal((String)">"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(Mth.clamp((int)(this.getPageIndex() + 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.init();
        }).pos(startX + 99, startY - 101).size(20, 20).build();
        if (this.getPageIndex() == 0) {
            prePage.active = false;
        }
        if (this.getPageIndex() == this.guiNumber.getPageSize() - 1) {
            nextPage.active = false;
        }
        this.addRenderableWidget((GuiEventListener)prePage);
        this.addRenderableWidget((GuiEventListener)nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        if (index == this.guiNumber.getTabIndex(this.getPackIndex()) && !this.isSearchMode) {
            this.addRenderableWidget((GuiEventListener)new TouhouImageButton(startX - 98 + 28 * index, startY - 108, 28, 31, 116, 224, 0, BG, NO_PRESS));
            return;
        }
        if (index < this.guiNumber.getTabSize(this.getPackIndex())) {
            this.addRenderableWidget((GuiEventListener)new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, b -> {
                ImageButtonWithId imageButton = (ImageButtonWithId)b;
                int packIndex = this.guiNumber.tabToPackIndex(imageButton.getIndex(), this.getPageIndex());
                this.setRowIndex(0);
                this.setPackIndex(packIndex);
                this.isSearchMode = false;
                this.searchText = "";
                this.init();
            }));
        }
    }

    private void addSearchTabButton(int startX, int startY) {
        int searchTabX = startX - 121;
        int searchTabY = startY + 100;
        if (this.isSearchMode) {
            this.addRenderableWidget((GuiEventListener)new TouhouImageButton(searchTabX, searchTabY - 4, 24, 26, 145, 194, 0, BG, NO_PRESS));
        } else {
            this.addRenderableWidget((GuiEventListener)new TouhouImageButton(searchTabX, searchTabY, 24, 21, 145, 220, 0, BG, b -> {
                this.setRowIndex(0);
                this.isSearchMode = true;
                this.init();
            }));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBlurredBackground(partialTicks);
        graphics.pose().translate(0.0f, 0.0f, -100.0f);
        int middleX = this.width / 2 + 50;
        int middleY = this.height / 2;
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(BG, middleX - 128, middleY - 80, 0, 0, 256, 180);
        graphics.blit(SIDE, middleX - 128 + 250, middleY - 80, 0, 0, 24, 180);
        this.drawScrollSide(graphics, middleX, middleY);
        this.drawButton(graphics, mouseX, mouseY, partialTicks);
        this.drawTabIcon(graphics, middleX, middleY);
        this.drawLeftEntity(graphics, middleX, middleY, mouseX, mouseY);
        this.drawEntity(graphics, middleX, middleY);
        this.drawTooltips(graphics, mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable button : this.renderables) {
            button.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(GuiGraphics graphics, int middleX, int middleY) {
        if (this.canScrollCurrentList()) {
            graphics.blit(SIDE, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.getCurrentScrollPosition()), 24, 0, 12, 15);
        } else {
            graphics.blit(SIDE, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.getCurrentScrollPosition()), 36, 0, 12, 15);
        }
    }

    private void drawTabIcon(GuiGraphics graphics, int middleX, int middleY) {
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            CustomModelPack<E> pack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            ResourceLocation icon = pack.getIcon();
            if (icon == null) continue;
            AbstractTexture iconTexture = Minecraft.getInstance().getTextureManager().getTexture(icon, (AbstractTexture)EMPTY_ICON_TEXTURE);
            if (EMPTY_ICON_TEXTURE.equals(iconTexture)) {
                icon = EMPTY_ICON;
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(pack, icon);
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                graphics.blit(icon, middleX - 92 + 28 * index, middleY - 98, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            int time = this.getTickTime() / pack.getIconDelay();
            int iconIndex = time % pack.getIconAspectRatio();
            graphics.blit(icon, middleX - 92 + 28 * index, middleY - 98, 0.0f, (float)(iconIndex * 16), 16, 16, 16, 16 * pack.getIconAspectRatio());
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, ResourceLocation icon) {
        AbstractTexture iconText = this.getMinecraft().getTextureManager().getTexture(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            SizeTexture sizeTexture = (SizeTexture)iconText;
            int width = sizeTexture.getWidth();
            if (width >= (height = sizeTexture.getHeight())) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    private void drawEntity(GuiGraphics graphics, int middleX, int middleY) {
        if (!this.isSearchMode) {
            CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
            this.drawPackInfoText(graphics, pack, middleX, middleY);
        }
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -38;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex >= displayList.size()) {
            return;
        }
        int toIndex = Math.min(fromIndex + 55, displayList.size());
        for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
            this.drawRightEntity(graphics, middleX + offsetX, middleY + offsetY, modelItem);
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void drawPackInfoText(GuiGraphics graphics, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 128) / 2;
        MutableComponent packName = ParseI18n.parse(pack.getPackName());
        List packSplitName = this.font.getSplitter().splitLines((FormattedText)packName, middleX - 128 - 20, Style.EMPTY);
        for (FormattedText properties : packSplitName) {
            graphics.drawCenteredString(this.font, properties.getString(), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        for (Component str : ParseI18n.parse(pack.getDescription())) {
            List split = this.font.getSplitter().splitLines((FormattedText)str, middleX - 128 - 20, Style.EMPTY);
            for (FormattedText properties : split) {
                graphics.drawCenteredString(this.font, properties.getString(), sideMiddleX, middleY + (offsetY += 10), 0x777777);
            }
        }
        if (!pack.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pack.getAuthor(), (int)2)) {
                graphics.drawCenteredString(this.font, (Component)Component.literal((String)textList.toString()).withStyle(ChatFormatting.GOLD), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
            }
        }
        if (pack.getVersion() != null) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.skin.text.version", (Object[])new Object[]{pack.getVersion()}).withStyle(ChatFormatting.DARK_AQUA), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        if (pack.getDate() != null) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{pack.getDate()}).withStyle(ChatFormatting.GREEN), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        graphics.drawCenteredString(this.font, String.format("%s/%s", this.getPageIndex() + 1, this.guiNumber.getPageSize()), middleX, middleY - 118, 0xFFFFFF);
    }

    private void drawTooltips(GuiGraphics graphics, int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex < displayList.size()) {
            int toIndex = Math.min(fromIndex + 55, displayList.size());
            for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
                boolean isyInRange;
                boolean isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
                boolean bl = isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;
                if (isxInRange && isyInRange) {
                    ArrayList<String> str = new ArrayList<String>();
                    str.add(modelItem.getName());
                    str.addAll(modelItem.getDescription());
                    List<Component> tooltips = ParseI18n.parse(str);
                    this.addModelCustomTips(modelItem, tooltips);
                    if (!modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.encrypt}") && !modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.normal}")) {
                        tooltips.add((Component)Component.translatable((String)"gui.touhou_little_maid.skin.tooltips.show_details").withStyle(ChatFormatting.DARK_PURPLE));
                    }
                    if (this.getMinecraft().options.advancedItemTooltips) {
                        tooltips.add((Component)Component.literal((String)modelItem.getModelId().toString()).withStyle(ChatFormatting.DARK_GRAY));
                    }
                    if (this.isSearchMode) {
                        CustomModelPack<IModelInfo> modelPack = this.findPackForModel(modelItem);
                        if (modelPack != null) {
                            tooltips.add((Component)ParseI18n.parse(modelPack.getPackName()).withStyle(ChatFormatting.BLUE));
                        }
                    } else {
                        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
                        tooltips.add((Component)ParseI18n.parse(pack.getPackName()).withStyle(ChatFormatting.BLUE));
                    }
                    graphics.renderComponentTooltip(this.font, tooltips, mouseX, mouseY);
                }
                if ((offsetX += 20) <= 105) continue;
                offsetX = -100;
                offsetY += 30;
            }
        }
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            boolean isyInRange;
            boolean isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean bl = isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (!isxInRange || !isyInRange) continue;
            CustomModelPack<E> hoverPack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            graphics.renderTooltip(this.font, (Component)ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
        }
        boolean xInRange = middleX + 122 < mouseX && mouseX < middleX + 143;
        boolean bl = yInRange = middleY - 97 < mouseY && mouseY < middleY - 80;
        if (xInRange && yInRange) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY != 0.0) {
            int row;
            int index = 0;
            if (deltaY > 0.0) {
                index = 1;
            }
            if (deltaY < 0.0) {
                index = -1;
            }
            if ((row = Mth.clamp((int)(this.getRowIndex() - index), (int)0, (int)this.getDisplayRowSize())) != this.getRowIndex()) {
                this.setRowIndex(row);
                this.init();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.searchBox != null && this.searchBox.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.searchBox);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.isFocused() && this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.isFocused() && this.searchBox.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private void onSearchTextChanged(String text) {
        if (!this.searchText.equals(text)) {
            this.searchText = text;
            this.setRowIndex(0);
            this.init();
        }
    }

    private void updateFilteredModelList() {
        if (this.isSearchMode) {
            if (StringUtils.isBlank((CharSequence)this.searchText)) {
                this.filteredModelList = this.allModelsList;
            } else {
                String lowerSearchText = this.searchText.toLowerCase(Locale.ENGLISH).trim();
                this.filteredModelList = this.allModelsList.stream().filter(model -> this.filterKeyWord(model, lowerSearchText)).collect(Collectors.toList());
            }
        } else {
            this.filteredModelList = null;
        }
    }

    private boolean filterKeyWord(E model, String keyword) {
        String modelName = ParseI18n.getI18nValue(model.getName());
        if (modelName.toLowerCase(Locale.ENGLISH).contains(keyword)) {
            return true;
        }
        for (String desc : model.getDescription()) {
            String descText = ParseI18n.getI18nValue(desc);
            if (!descText.toLowerCase(Locale.ENGLISH).contains(keyword)) continue;
            return true;
        }
        String modelId = model.getModelId().toString().toLowerCase(Locale.ENGLISH);
        return modelId.contains(keyword);
    }

    private List<E> getDisplayModelList() {
        if (this.isSearchMode) {
            return Objects.requireNonNullElseGet(this.filteredModelList, () -> Objects.requireNonNullElse(this.allModelsList, Collections.emptyList()));
        }
        return this.modelPackList.get(this.getPackIndex()).getModelList();
    }

    private int getDisplayRowSize() {
        List<E> displayList = this.getDisplayModelList();
        if (displayList == null || displayList.isEmpty()) {
            return 0;
        }
        int row = (displayList.size() - 1) / 11 + 1;
        return Math.max(row - 5, 0);
    }

    private CustomModelPack<E> findPackForModel(E model) {
        for (CustomModelPack<E> pack : this.modelPackList) {
            if (!pack.getModelList().contains(model)) continue;
            return pack;
        }
        return null;
    }

    private boolean canScrollCurrentList() {
        if (this.isSearchMode) {
            List<E> displayList = this.getDisplayModelList();
            int modelSize = displayList.size() - 11 * this.getRowIndex();
            return modelSize > 55;
        }
        return this.guiNumber.canScroll(this.getPackIndex(), this.getRowIndex());
    }

    private float getCurrentScrollPosition() {
        if (this.isSearchMode) {
            List<E> displayList = this.getDisplayModelList();
            if (displayList.isEmpty()) {
                return 0.0f;
            }
            int totalRows = (displayList.size() - 1) / 11;
            int maxScroll = Math.max(totalRows - 4, 0);
            if (maxScroll == 0) {
                return 0.0f;
            }
            return Mth.clamp((float)((float)((double)this.getRowIndex() * (1.0 / (double)maxScroll))), (float)0.0f, (float)1.0f);
        }
        return this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex());
    }

    protected void onClickCloseButton() {
        this.onClose();
    }
}

