/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.network.message.DismountPackage;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class DismountBroomKey {
    public static final KeyMapping DISMOUNT_KEY = new KeyMapping("key.touhou_little_maid.dismount.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 67, "key.category.touhou_little_maid");

    @SubscribeEvent
    public static void onDismountPress(InputEvent.Key event) {
        if (DismountBroomKey.keyIsMatch(event)) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.isSpectator()) {
                return;
            }
            if (!DismountBroomKey.isInGame()) {
                return;
            }
            DISMOUNT_KEY.consumeClick();
            if (event.getAction() == 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new DismountPackage(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static boolean keyIsMatch(InputEvent.Key event) {
        return DISMOUNT_KEY.matches(event.getKey(), event.getScanCode()) && DISMOUNT_KEY.getKeyModifier().equals((Object)KeyModifier.getActiveModifier());
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getOverlay() != null) {
            return false;
        }
        if (mc.screen != null) {
            return false;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return false;
        }
        return mc.isWindowActive();
    }
}

