/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.Player2AppCheck;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.STTCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTSite;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class STTChatKey {
    public static final KeyMapping STT_CHAT_KEY = new KeyMapping("key.touhou_little_maid.stt_chat.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 88, "key.category.touhou_little_maid");

    @SubscribeEvent
    public static void onSttChatPress(InputEvent.Key event) {
        if (STTChatKey.keyIsMatch(event)) {
            if (!((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue()) {
                return;
            }
            if (!((Boolean)AIConfig.STT_ENABLED.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || player.isSpectator()) {
                return;
            }
            if (!STTChatKey.isInGame()) {
                return;
            }
            STT_CHAT_KEY.consumeClick();
            if (event.getAction() == 1) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)InitSounds.RECORDING_START.get()), (float)1.0f));
                STTChatKey.getNearestMaid(player, STTChatKey::sttStart, true);
                return;
            }
            if (event.getAction() == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)InitSounds.RECORDING_END.get()), (float)1.0f));
                STTChatKey.getNearestMaid(player, STTChatKey::sttStop, false);
            }
        }
    }

    private static boolean keyIsMatch(InputEvent.Key event) {
        return STT_CHAT_KEY.matches(event.getKey(), event.getScanCode()) && STT_CHAT_KEY.getKeyModifier().equals((Object)KeyModifier.getActiveModifier());
    }

    private static void getNearestMaid(LocalPlayer player, Consumer<EntityMaid> consumer, boolean isStart) {
        Level level = player.level;
        int range = (Integer)AIConfig.MAID_CAN_CHAT_DISTANCE.get();
        AABB aabb = player.getBoundingBox().inflate((double)range);
        List maids = level.getEntitiesOfClass(EntityMaid.class, aabb, maid -> maid.isOwnedBy((LivingEntity)player) && maid.isAlive());
        maids.sort(Comparator.comparingDouble(maid -> maid.distanceToSqr((Entity)player)));
        if (!maids.isEmpty()) {
            consumer.accept((EntityMaid)maids.get(0));
            return;
        }
        if (isStart) {
            player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.stt.no_maid_found", (Object[])new Object[]{range}));
        }
    }

    private static boolean isInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getOverlay() != null) {
            return false;
        }
        if (mc.screen != null) {
            return false;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return false;
        }
        return mc.isWindowActive();
    }

    private static void sttStart(EntityMaid maid) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        STTSite sttSite = AvailableSites.getSTTSite(((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName());
        if (!sttSite.enabled()) {
            player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.stt.empty"));
            return;
        }
        if (sttSite.id().equals(DefaultLLMSite.PLAYER2.id())) {
            Player2AppCheck.checkPlayer2AppInStt((Player)player, () -> STTChatKey.tryToStart(maid, player, sttSite));
        } else {
            STTChatKey.tryToStart(maid, player, sttSite);
        }
    }

    private static void tryToStart(EntityMaid maid, LocalPlayer player, STTSite sttSite) {
        STTConfig config = new STTConfig();
        STTCallback callback = new STTCallback((Player)player, maid);
        sttSite.client().startRecord(config, callback);
    }

    private static void sttStop(EntityMaid maid) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        STTSite sttSite = AvailableSites.getSTTSite(((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName());
        if (sttSite.enabled()) {
            STTConfig config = new STTConfig();
            STTCallback callback = new STTCallback((Player)player, maid);
            sttSite.client().stopRecord(config, callback);
        }
    }
}

