/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ExperienceOrbRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ReplaceExperienceOrbRenderer
extends EntityRenderer<ExperienceOrb> {
    private static final ResourceLocation POINT_ITEM_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/point_item.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)POINT_ITEM_TEXTURE);
    private final ExperienceOrbRenderer vanillaRender;

    public ReplaceExperienceOrbRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
        this.vanillaRender = new ExperienceOrbRenderer(context);
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        Vector3f vector3f = pMatrixNormal.transform(new Vector3f(0.0f, 1.0f, 0.0f));
        pConsumer.addVertex(pMatrix, pX, pY, 0.0f).setColor(pRed, pGreen, pBlue, 128).setUv(pTexU, pTexV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
    }

    protected int getBlockLightLevel(ExperienceOrb pEntity, BlockPos pPos) {
        return Mth.clamp((int)(super.getBlockLightLevel((Entity)pEntity, pPos) + 7), (int)0, (int)15);
    }

    public void render(ExperienceOrb orb, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_XP_TEXTURE.get()).booleanValue()) {
            this.renderPointItem(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.render(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderPointItem(ExperienceOrb orb, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        int icon = orb.getIcon();
        float texU1 = (float)(icon % 4 * 16) / 64.0f;
        float texU2 = (float)(icon % 4 * 16 + 16) / 64.0f;
        float texV2 = (float)(icon / 4 * 16) / 64.0f;
        float texV1 = (float)(icon / 4 * 16 + 16) / 64.0f;
        poseStack.translate(0.0f, 0.1f, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.3f, 0.3f, 0.3f);
        VertexConsumer consumer = buffer.getBuffer(RENDER_TYPE);
        PoseStack.Pose lasted = poseStack.last();
        Matrix4f pose = lasted.pose();
        Matrix3f normal = lasted.normal();
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, -0.5f, -0.25f, 255, 255, 255, texU1, texV1, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, 0.5f, -0.25f, 255, 255, 255, texU2, texV1, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, 0.5f, 0.75f, 255, 255, 255, texU2, texV2, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, -0.5f, 0.75f, 255, 255, 255, texU1, texV2, packedLight);
        poseStack.popPose();
        super.render((Entity)orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ExperienceOrb pEntity) {
        return POINT_ITEM_TEXTURE;
    }
}

