/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ReplaceableBakedModel
implements BakedModel {
    private final BakedModel rawBakedModel;
    private final BakedModel replacedBakedModel;
    private final Supplier<Boolean> isReplace;

    public ReplaceableBakedModel(BakedModel rawBakedModel, BakedModel replacedBakedModel, Supplier<Boolean> isReplace) {
        this.rawBakedModel = rawBakedModel;
        this.replacedBakedModel = replacedBakedModel;
        this.isReplace = isReplace;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource random) {
        if (this.isReplace.get().booleanValue()) {
            return this.replacedBakedModel.getQuads(pState, pDirection, random);
        }
        return this.rawBakedModel.getQuads(pState, pDirection, random);
    }

    public boolean useAmbientOcclusion() {
        return this.rawBakedModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.rawBakedModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.rawBakedModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.rawBakedModel.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        if (this.isReplace.get().booleanValue()) {
            return this.replacedBakedModel.getOverrides();
        }
        return this.rawBakedModel.getOverrides();
    }

    public BakedModel applyTransform(ItemDisplayContext type, PoseStack mat, boolean applyLeftHandTransform) {
        if (this.isReplace.get().booleanValue()) {
            return this.replacedBakedModel.applyTransform(type, mat, applyLeftHandTransform);
        }
        return this.rawBakedModel.applyTransform(type, mat, applyLeftHandTransform);
    }
}

