/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class TileEntityAltarRenderer
implements BlockEntityRenderer<TileEntityAltar> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/bedrock/block/altar.png");
    private final SimpleBedrockModel<? extends Entity> model = BedrockModelLoader.getModel(BedrockModelLoader.ALTAR);

    public TileEntityAltarRenderer(BlockEntityRendererProvider.Context render) {
    }

    public void render(TileEntityAltar te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRender()) {
            poseStack.pushPose();
            this.setTranslateAndPose(te, poseStack);
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            this.model.renderToBuffer(poseStack, buffer, combinedLightIn, combinedOverlayIn);
            poseStack.popPose();
        }
        if (te.isCanPlaceItem() && !te.handler.getStackInSlot(0).isEmpty()) {
            ItemStack stack = te.handler.getStackInSlot(0);
            poseStack.pushPose();
            double time = (System.currentTimeMillis() + te.getBlockPos().asLong()) % 3600L;
            poseStack.translate(0.5, 1.25 + Math.sin(time / 1800.0 * Math.PI) * 0.1, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)time / 10.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, te.getLevel(), 0);
            poseStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(TileEntityAltar te) {
        return true;
    }

    private void setTranslateAndPose(TileEntityAltar te, PoseStack poseStack) {
        switch (te.getDirection()) {
            case SOUTH: {
                poseStack.translate(1.0, -1.5, -3.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.translate(-3.0, -1.5, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                poseStack.translate(4.0, -1.5, 1.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            default: {
                poseStack.translate(0.0, -1.5, 4.0);
            }
        }
    }

    public AABB getRenderBoundingBox(TileEntityAltar te) {
        return RenderHelper.getAABB(te.getWorldPosition().offset(-9, -5, -9), te.getWorldPosition().offset(9, 5, 9));
    }
}

